/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.test.data;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityFactoryRegistry;
import org.molgenis.data.EntityReferenceCreator;
import org.molgenis.data.EntityReferenceCreatorImpl;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.AttributeMetadata;
import org.molgenis.data.meta.model.EntityTypeMetadata;
import org.molgenis.data.support.DataServiceImpl;
import org.molgenis.util.GenericDependencyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeClass;

@ContextConfiguration(classes={Config.class})
public abstract class AbstractMolgenisSpringTest
extends AbstractTestNGSpringContextTests {
    @BeforeClass
    public void bootstrap() {
        EntityTypeMetadata entityTypeMeta = (EntityTypeMetadata)this.applicationContext.getBean(EntityTypeMetadata.class);
        entityTypeMeta.setBackendEnumOptions((List)Lists.newArrayList((Object[])new String[]{"test"}));
        ((AttributeMetadata)this.applicationContext.getBean(AttributeMetadata.class)).bootstrap(entityTypeMeta);
        Map systemEntityTypeMap = this.applicationContext.getBeansOfType(SystemEntityType.class);
        new GenericDependencyResolver().resolve(systemEntityTypeMap.values(), SystemEntityType::getDependencies).stream().forEach(systemEntityType -> systemEntityType.bootstrap(entityTypeMeta));
    }

    @Configuration
    @ComponentScan(value={"org.molgenis.data.meta.model", "org.molgenis.data.system.model", "org.molgenis.data.populate", "org.molgenis.test.data"})
    public static class Config {
        @Bean
        public GenericDependencyResolver genericDependencyResolver() {
            return new GenericDependencyResolver();
        }

        @Bean
        public DataService dataService() {
            return new DataServiceImpl();
        }

        @Bean
        public EntityFactoryRegistry entityFactoryRegistry() {
            return new EntityFactoryRegistry();
        }

        @Bean
        public EntityReferenceCreator entityReferenceCreator() {
            return new EntityReferenceCreatorImpl(this.dataService(), this.entityFactoryRegistry());
        }
    }
}

