/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.test.data;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.meta.model.PackageFactory;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.test.data.TestPackage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntitySelfXrefTestHarness {
    public static final String ATTR_ID = "id_attr";
    public static final String ATTR_XREF = "xref_attr";
    public static final String ATTR_STRING = "string_attr";
    @Autowired
    private PackageFactory packageFactory;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attributeFactory;
    @Autowired
    private TestPackage testPackage;

    @PostConstruct
    public void postConstruct() {
    }

    public EntityType createDynamicEntityType() {
        return ((EntityType)this.entityTypeFactory.create()).setSimpleName("SelfRef").setBackend("PostgreSQL").addAttribute(this.createAttribute(ATTR_ID, AttributeType.STRING), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).addAttribute(this.createAttribute(ATTR_XREF, AttributeType.XREF), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_STRING, AttributeType.STRING).setNillable(false), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL});
    }

    private Attribute createAttribute(String name, AttributeType dataType) {
        return this.attributeFactory.create().setName(name).setDataType(dataType);
    }

    public Stream<Entity> createTestEntities(EntityType entityType, int numberOfEntities) {
        return IntStream.range(0, numberOfEntities).mapToObj(i -> this.createEntity(entityType, i));
    }

    private Entity createEntity(EntityType entityType, int id) {
        DynamicEntity entity1 = new DynamicEntity(entityType);
        entity1.set(ATTR_ID, (Object)("" + id));
        entity1.set(ATTR_XREF, (Object)entity1);
        entity1.set(ATTR_STRING, (Object)"attr_string_old");
        return entity1;
    }
}

