/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.test.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.meta.model.PackageFactory;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.support.EntityWithComputedAttributes;
import org.molgenis.test.data.TestPackage;
import org.molgenis.test.data.staticentity.TestEntityStaticMetaData;
import org.molgenis.test.data.staticentity.TestRefEntityStaticMetaData;
import org.molgenis.util.MolgenisDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityTestHarness {
    public static final String ATTR_ID = "id_attr";
    public static final String ATTR_STRING = "string_attr";
    public static final String ATTR_BOOL = "bool_attr";
    public static final String ATTR_CATEGORICAL = "categorical_attr";
    public static final String ATTR_CATEGORICAL_MREF = "categorical_mref_attr";
    public static final String ATTR_DATE = "date_attr";
    public static final String ATTR_DATETIME = "datetime_attr";
    public static final String ATTR_DECIMAL = "decimal_attr";
    public static final String ATTR_HTML = "html_attr";
    public static final String ATTR_HYPERLINK = "hyperlink_attr";
    public static final String ATTR_LONG = "long_attr";
    public static final String ATTR_INT = "int_attr";
    public static final String ATTR_SCRIPT = "script_attr";
    public static final String ATTR_EMAIL = "email_attr";
    public static final String ATTR_XREF = "xref_attr";
    public static final String ATTR_MREF = "mref_attr";
    public static final String ATTR_REF_ID = "ref_id_attr";
    public static final String ATTR_REF_STRING = "ref_string_attr";
    public static final String ATTR_COMPUTED_INT = "computed_int_attr";
    public static final String ATTR_COMPOUND = "compound_attr";
    public static final String ATTR_COMPOUND_CHILD_INT = "compound_child_int_attr";
    @Autowired
    private PackageFactory packageFactory;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attributeFactory;
    @Autowired
    TestEntityStaticMetaData staticTestEntityStaticMetaData;
    @Autowired
    TestRefEntityStaticMetaData staticTestRefEntityStaticMetaData;
    @Autowired
    private TestPackage testPackage;
    private Date date;
    private Date dateTime;

    @PostConstruct
    public void postConstruct() {
    }

    public EntityType createStaticRefTestEntityType() {
        return this.staticTestRefEntityStaticMetaData;
    }

    public EntityType createStaticTestEntityType() {
        return this.staticTestEntityStaticMetaData;
    }

    public EntityType createDynamicRefEntityType() {
        return ((EntityType)this.entityTypeFactory.create()).setName("TypeTestRefDynamic").setBackend("PostgreSQL").addAttribute(this.createAttribute(ATTR_REF_ID, AttributeType.STRING), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).addAttribute(this.createAttribute(ATTR_REF_STRING, AttributeType.STRING).setNillable(false), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL});
    }

    public EntityType createDynamicTestEntityType(EntityType refEntityType) {
        EntityType entityType = ((EntityType)this.entityTypeFactory.create()).setName("TypeTestDynamic").setBackend("PostgreSQL");
        entityType.addAttribute(this.createAttribute(ATTR_ID, AttributeType.STRING).setAuto(true), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).addAttribute(this.createAttribute(ATTR_STRING, AttributeType.STRING).setNillable(false), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL}).addAttribute(this.createAttribute(ATTR_BOOL, AttributeType.BOOL), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_CATEGORICAL, AttributeType.CATEGORICAL).setRefEntity(refEntityType), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_CATEGORICAL_MREF, AttributeType.CATEGORICAL_MREF).setRefEntity(refEntityType), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_DATE, AttributeType.DATE), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_DATETIME, AttributeType.DATE_TIME), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_EMAIL, AttributeType.EMAIL), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_DECIMAL, AttributeType.DECIMAL), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_HTML, AttributeType.HTML), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_HYPERLINK, AttributeType.HYPERLINK), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_LONG, AttributeType.LONG), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_INT, AttributeType.INT), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_SCRIPT, AttributeType.SCRIPT), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_XREF, AttributeType.XREF).setRefEntity(refEntityType), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_MREF, AttributeType.MREF).setRefEntity(refEntityType), new EntityType.AttributeRole[0]).addAttribute(this.createAttribute(ATTR_COMPUTED_INT, AttributeType.INT).setExpression(ATTR_INT), new EntityType.AttributeRole[0]);
        Attribute compound = this.createAttribute(ATTR_COMPOUND, AttributeType.COMPOUND);
        Attribute child = this.createAttribute(ATTR_COMPOUND_CHILD_INT, AttributeType.INT).setParent(compound);
        return entityType.addAttribute(compound, new EntityType.AttributeRole[0]).addAttribute(child, new EntityType.AttributeRole[0]);
    }

    private Attribute createAttribute(String name, AttributeType dataType) {
        return this.attributeFactory.create().setName(name).setDataType(dataType);
    }

    public List<Entity> createTestRefEntities(EntityType refEntityType, int numberOfEntities) {
        return IntStream.range(0, numberOfEntities).mapToObj(i -> this.createRefEntity(refEntityType, i)).collect(Collectors.toList());
    }

    public Stream<Entity> createTestEntities(EntityType entityType, int numberOfEntities, List<Entity> refEntities) {
        return IntStream.range(0, numberOfEntities).mapToObj(i -> this.createEntity(entityType, i, (Entity)refEntities.get(i % refEntities.size())));
    }

    private Entity createRefEntity(EntityType refEntityType, int id) {
        DynamicEntity refEntity = new DynamicEntity(refEntityType);
        refEntity.set(ATTR_REF_ID, (Object)("" + id));
        refEntity.set(ATTR_REF_STRING, (Object)("refstring" + id));
        return refEntity;
    }

    private Entity createEntity(EntityType entityType, int id, Entity refEntity) {
        if (this.date == null || this.dateTime == null) {
            this.generateDateAndDateTime();
        }
        DynamicEntity entity = new DynamicEntity(entityType);
        entity.set(ATTR_ID, (Object)("" + id));
        entity.set(ATTR_STRING, (Object)"string1");
        entity.set(ATTR_BOOL, (Object)(id % 2 == 0 ? 1 : 0));
        entity.set(ATTR_CATEGORICAL, (Object)refEntity);
        entity.set(ATTR_CATEGORICAL_MREF, Collections.singletonList(refEntity));
        entity.set(ATTR_DATE, (Object)this.date);
        entity.set(ATTR_DATETIME, (Object)this.dateTime);
        entity.set(ATTR_EMAIL, (Object)"this.is@mail.address");
        entity.set(ATTR_DECIMAL, (Object)((double)id + 0.123));
        entity.set(ATTR_HTML, (Object)(id % 2 == 1 ? "<html>where is my head and where is my body</html>" : null));
        entity.set(ATTR_HYPERLINK, (Object)"http://www.molgenis.org");
        entity.set(ATTR_LONG, (Object)((long)id * 1000000L));
        entity.set(ATTR_INT, (Object)(10 + id));
        entity.set(ATTR_SCRIPT, (Object)"/bin/blaat/script.sh");
        entity.set(ATTR_XREF, (Object)refEntity);
        entity.set(ATTR_MREF, Collections.singletonList(refEntity));
        entity.set(ATTR_COMPOUND_CHILD_INT, (Object)(10 + id));
        return new EntityWithComputedAttributes((Entity)entity);
    }

    private void generateDateAndDateTime() {
        SimpleDateFormat dateFormat = MolgenisDateFormat.getDateFormat();
        SimpleDateFormat dateTimeFormat = MolgenisDateFormat.getDateTimeFormat();
        try {
            this.date = dateFormat.parse("2012-12-21");
            this.dateTime = dateTimeFormat.parse("1985-08-12T11:12:13+0500");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void addSelfReference(EntityType selfXrefEntityType) {
        Attribute selfRef = this.createAttribute(ATTR_XREF, AttributeType.XREF);
        selfRef.setRefEntity(selfXrefEntityType);
        selfXrefEntityType.addAttribute(selfRef, new EntityType.AttributeRole[0]);
    }
}

