/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.test.data;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.molgenis.data.AbstractSystemEntityFactory;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.test.data.staticentity.bidirectional.authorbook1.AuthorFactory1;
import org.molgenis.test.data.staticentity.bidirectional.authorbook1.AuthorMetaData1;
import org.molgenis.test.data.staticentity.bidirectional.authorbook1.BookFactory1;
import org.molgenis.test.data.staticentity.bidirectional.authorbook1.BookMetaData1;
import org.molgenis.test.data.staticentity.bidirectional.authorbook2.AuthorFactory2;
import org.molgenis.test.data.staticentity.bidirectional.authorbook2.AuthorMetaData2;
import org.molgenis.test.data.staticentity.bidirectional.authorbook2.BookFactory2;
import org.molgenis.test.data.staticentity.bidirectional.authorbook2.BookMetaData2;
import org.molgenis.test.data.staticentity.bidirectional.authorbook3.AuthorFactory3;
import org.molgenis.test.data.staticentity.bidirectional.authorbook3.AuthorMetaData3;
import org.molgenis.test.data.staticentity.bidirectional.authorbook3.BookFactory3;
import org.molgenis.test.data.staticentity.bidirectional.authorbook3.BookMetaData3;
import org.molgenis.test.data.staticentity.bidirectional.authorbook4.AuthorFactory4;
import org.molgenis.test.data.staticentity.bidirectional.authorbook4.AuthorMetaData4;
import org.molgenis.test.data.staticentity.bidirectional.authorbook4.BookFactory4;
import org.molgenis.test.data.staticentity.bidirectional.authorbook4.BookMetaData4;
import org.molgenis.test.data.staticentity.bidirectional.person1.PersonFactory1;
import org.molgenis.test.data.staticentity.bidirectional.person1.PersonMetaData1;
import org.molgenis.test.data.staticentity.bidirectional.person2.PersonFactory2;
import org.molgenis.test.data.staticentity.bidirectional.person2.PersonMetaData2;
import org.molgenis.test.data.staticentity.bidirectional.person3.PersonFactory3;
import org.molgenis.test.data.staticentity.bidirectional.person3.PersonMetaData3;
import org.molgenis.test.data.staticentity.bidirectional.person4.PersonFactory4;
import org.molgenis.test.data.staticentity.bidirectional.person4.PersonMetaData4;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OneToManyTestHarness {
    @Autowired
    AuthorFactory1 authorFactory1;
    @Autowired
    AuthorFactory2 authorFactory2;
    @Autowired
    AuthorFactory3 authorFactory3;
    @Autowired
    AuthorFactory4 authorFactory4;
    @Autowired
    AuthorMetaData1 authorMetaData1;
    @Autowired
    AuthorMetaData2 authorMetaData2;
    @Autowired
    AuthorMetaData3 authorMetaData3;
    @Autowired
    AuthorMetaData4 authorMetaData4;
    @Autowired
    BookFactory1 bookFactory1;
    @Autowired
    BookFactory2 bookFactory2;
    @Autowired
    BookFactory3 bookFactory3;
    @Autowired
    BookFactory4 bookFactory4;
    @Autowired
    BookMetaData1 bookMetaData1;
    @Autowired
    BookMetaData2 bookMetaData2;
    @Autowired
    BookMetaData3 bookMetaData3;
    @Autowired
    BookMetaData4 bookMetaData4;
    @Autowired
    PersonFactory1 personFactory1;
    @Autowired
    PersonFactory2 personFactory2;
    @Autowired
    PersonFactory3 personFactory3;
    @Autowired
    PersonFactory4 personFactory4;
    @Autowired
    PersonMetaData1 personMetaData1;
    @Autowired
    PersonMetaData2 personMetaData2;
    @Autowired
    PersonMetaData3 personMetaData3;
    @Autowired
    PersonMetaData4 personMetaData4;
    public static final int ONE_TO_MANY_CASES = 4;
    public static final String BOOK_1 = "book1";
    public static final String BOOK_2 = "book2";
    public static final String BOOK_3 = "book3";
    public static final String AUTHOR_1 = "author1";
    public static final String AUTHOR_2 = "author2";
    public static final String AUTHOR_3 = "author3";
    public static final String ATTR_BOOKS = "books";
    public static final String ATTR_AUTHOR = "author";
    public static final String PERSON_1 = "person1";
    public static final String PERSON_2 = "person2";
    public static final String PERSON_3 = "person3";
    public static final String ATTR_PARENT = "parent";
    public static final String ATTR_CHILDREN = "children";

    @PostConstruct
    public void postConstruct() {
    }

    public AuthorsAndBooks createAuthorAndBookEntities(TestCaseType testCase) {
        switch (testCase) {
            case XREF_NULLABLE: {
                return this.createTestEntitiesSetBooksField(this.authorFactory1, this.bookFactory1, (EntityType)this.authorMetaData1, (EntityType)this.bookMetaData1);
            }
            case XREF_REQUIRED: {
                return this.createTestEntitiesSetBooksField(this.authorFactory2, this.bookFactory2, (EntityType)this.authorMetaData2, (EntityType)this.bookMetaData2);
            }
            case ASCENDING_ORDER: {
                return this.createTestEntitiesSetBooksField(this.authorFactory3, this.bookFactory3, (EntityType)this.authorMetaData3, (EntityType)this.bookMetaData3);
            }
            case DESCENDING_ORDER: {
                return this.createTestEntitiesSetBooksField(this.authorFactory4, this.bookFactory4, (EntityType)this.authorMetaData4, (EntityType)this.bookMetaData4);
            }
        }
        throw new IllegalArgumentException("Unknown test case " + (Object)((Object)testCase));
    }

    public List<Entity> createPersonEntities(TestCaseType testCase) {
        switch (testCase) {
            case XREF_NULLABLE: {
                return this.createPersonEntities(this.personFactory1);
            }
            case XREF_REQUIRED: {
                return this.createPersonEntities(this.personFactory2);
            }
            case ASCENDING_ORDER: {
                return this.createPersonEntities(this.personFactory3);
            }
            case DESCENDING_ORDER: {
                return this.createPersonEntities(this.personFactory4);
            }
        }
        throw new IllegalArgumentException("Unknown test case " + (Object)((Object)testCase));
    }

    private AuthorsAndBooks createTestEntitiesSetBooksField(AbstractSystemEntityFactory authorFactory, AbstractSystemEntityFactory bookFactory, EntityType authorMetaData, EntityType bookMetaData) {
        List<Entity> authors = this.createAuthorEntities(authorFactory);
        List<Entity> books = this.createBookEntities(bookFactory);
        books.get(0).set(ATTR_AUTHOR, (Object)authors.get(0));
        books.get(1).set(ATTR_AUTHOR, (Object)authors.get(1));
        books.get(2).set(ATTR_AUTHOR, (Object)authors.get(2));
        return new AuthorsAndBooks(authors, books, authorMetaData, bookMetaData);
    }

    private List<Entity> createAuthorEntities(AbstractSystemEntityFactory authorFactory) {
        Entity author1 = authorFactory.create();
        author1.set("id", (Object)AUTHOR_1);
        author1.set("label", (Object)"Fabian");
        Entity author2 = authorFactory.create();
        author2.set("id", (Object)AUTHOR_2);
        author2.set("label", (Object)"Mechteld");
        Entity author3 = authorFactory.create();
        author3.set("id", (Object)AUTHOR_3);
        author3.set("label", (Object)"Henk");
        return Lists.newArrayList((Object[])new Entity[]{author1, author2, author3});
    }

    private List<Entity> createBookEntities(AbstractSystemEntityFactory bookFactory) {
        Entity book1 = bookFactory.create();
        book1.set("id", (Object)BOOK_1);
        book1.set("label", (Object)"MOLGENIS for Dummies");
        Entity book2 = bookFactory.create();
        book2.set("id", (Object)BOOK_2);
        book2.set("label", (Object)"A history of MOLGENIS");
        Entity book3 = bookFactory.create();
        book3.set("id", (Object)BOOK_3);
        book3.set("label", (Object)"Do you know where MOLGENIS?");
        return Lists.newArrayList((Object[])new Entity[]{book1, book2, book3});
    }

    private List<Entity> createPersonEntities(AbstractSystemEntityFactory personFactory) {
        Entity person1 = personFactory.create();
        person1.set("id", (Object)PERSON_1);
        person1.set("label", (Object)"Roderique");
        Entity person2 = personFactory.create();
        person2.set("id", (Object)PERSON_2);
        person2.set("label", (Object)"Sjonny");
        Entity person3 = personFactory.create();
        person3.set("id", (Object)PERSON_3);
        person3.set("label", (Object)"Klaas");
        person1.set(ATTR_PARENT, (Object)person3);
        person2.set(ATTR_PARENT, (Object)person1);
        person3.set(ATTR_PARENT, (Object)person2);
        return Lists.newArrayList((Object[])new Entity[]{person1, person2, person3});
    }

    public static class AuthorsAndBooks {
        private final List<Entity> books;
        private final List<Entity> authors;
        private final EntityType bookMetaData;
        private final EntityType authorMetaData;

        AuthorsAndBooks(@NonNull List<Entity> authors, @NonNull List<Entity> books, @NonNull EntityType authorMetaData, @NonNull EntityType bookMetaData) {
            this.authors = Objects.requireNonNull(authors);
            this.books = Objects.requireNonNull(books);
            this.authorMetaData = Objects.requireNonNull(authorMetaData);
            this.bookMetaData = Objects.requireNonNull(bookMetaData);
        }

        public List<Entity> getBooks() {
            return this.books;
        }

        public List<Entity> getAuthors() {
            return this.authors;
        }

        public EntityType getBookMetaData() {
            return this.bookMetaData;
        }

        public EntityType getAuthorMetaData() {
            return this.authorMetaData;
        }
    }

    public static enum TestCaseType {
        XREF_NULLABLE,
        XREF_REQUIRED,
        ASCENDING_ORDER,
        DESCENDING_ORDER;

    }
}

