/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.test;

import com.google.common.io.Resources;
import freemarker.core.InvalidReferenceException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class TestResourceUtils {
    private static final Configuration CONFIGURATION = new Configuration(Configuration.VERSION_2_3_21);

    private TestResourceUtils() {
    }

    public static String getRenderedString(Class<?> contextClass, String resourceName) throws IOException {
        return TestResourceUtils.getRenderedString(contextClass, resourceName, Collections.emptyMap());
    }

    public static String getRenderedString(Class<?> contextClass, String resourceName, Map<String, String> model) throws IOException {
        String resourceContent = TestResourceUtils.getString(contextClass, resourceName);
        Template template = new Template("template", resourceContent, CONFIGURATION);
        HashMap<String, String> values = new HashMap<String, String>(model);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> values.put(key.toString(), (String)value)));
        StringWriter stringWriter = new StringWriter();
        try {
            template.process(values, (Writer)stringWriter);
        }
        catch (InvalidReferenceException e) {
            throw new IllegalArgumentException("did you forget to declare a system property?", e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("template error", e);
        }
        return stringWriter.toString();
    }

    public static String getString(Class<?> contextClass, String resourceName) throws IOException {
        URL resourceUrl = Resources.getResource(contextClass, (String)resourceName);
        return Resources.toString((URL)resourceUrl, (Charset)StandardCharsets.UTF_8);
    }
}

