/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaInfo;

public class VcfInfo {
    private final VcfMeta vcfMeta;
    private String key;
    private String val;

    public VcfInfo(VcfMeta vcfMeta) {
        this(vcfMeta, null, null);
    }

    public VcfInfo(VcfMeta vcfMeta, String key, String val) {
        if (vcfMeta == null) {
            throw new IllegalArgumentException("vcfMeta is null");
        }
        this.vcfMeta = vcfMeta;
        this.key = key;
        this.val = val;
    }

    public String getKey() {
        return this.key;
    }

    public Object getVal() {
        boolean isListValue;
        VcfMetaInfo vcfMetaInfo = this.vcfMeta.getInfoMeta(this.key);
        if (vcfMetaInfo == null) {
            return this.val;
        }
        String number = vcfMetaInfo.getNumber();
        try {
            isListValue = number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.valueOf(number) > 1;
        }
        catch (NumberFormatException ex) {
            throw new GenotypeDataException("Error parsing length of vcf info field. " + number + " is not a valid int or expected preset (A, R, G, .)", ex);
        }
        switch (vcfMetaInfo.getType()) {
            case CHARACTER: {
                if (isListValue) {
                    String[] valTokens = StringUtils.split((String)this.val, (char)',');
                    if (valTokens.length == 0) {
                        return Collections.emptyList();
                    }
                    ArrayList<Character> valList = new ArrayList<Character>(valTokens.length);
                    for (String valToken : valTokens) {
                        valList.add(Character.valueOf(valToken.charAt(0)));
                    }
                    return valList;
                }
                return Character.valueOf(this.val.charAt(0));
            }
            case FLAG: {
                return null;
            }
            case FLOAT: {
                if (isListValue) {
                    String[] valTokens = StringUtils.split((String)this.val, (char)',');
                    if (valTokens.length == 0) {
                        return Collections.emptyList();
                    }
                    ArrayList<Float> valList = new ArrayList<Float>(valTokens.length);
                    for (String valToken : valTokens) {
                        if (valToken.equals(".")) {
                            valList.add(null);
                            continue;
                        }
                        if (valToken.equalsIgnoreCase("nan") || valToken.equalsIgnoreCase("Na")) {
                            valList.add(Float.valueOf(Float.NaN));
                            continue;
                        }
                        try {
                            valList.add(Float.valueOf(valToken));
                        }
                        catch (NumberFormatException ex) {
                            throw new GenotypeDataException("Error parsing VCF info column value: " + valToken + " is not a float");
                        }
                    }
                    return valList;
                }
                if (this.val.equalsIgnoreCase("nan") || this.val.equalsIgnoreCase("Na")) {
                    return Float.valueOf(Float.NaN);
                }
                try {
                    return Float.valueOf(this.val);
                }
                catch (NumberFormatException ex) {
                    throw new GenotypeDataException("Error parsing VCF info column value: " + this.val + " is not a float");
                }
            }
            case INTEGER: {
                if (isListValue) {
                    String[] valTokens = StringUtils.split((String)this.val, (char)',');
                    if (valTokens.length == 0) {
                        return Collections.emptyList();
                    }
                    ArrayList<Integer> valList = new ArrayList<Integer>(valTokens.length);
                    for (String valToken : valTokens) {
                        if (valToken.equals(".")) {
                            valList.add(null);
                            continue;
                        }
                        try {
                            valList.add(Integer.valueOf(valToken));
                        }
                        catch (NumberFormatException ex) {
                            throw new GenotypeDataException("Error parsing VCF info column value: " + this.val + " is not a int");
                        }
                    }
                    return valList;
                }
                try {
                    return Integer.valueOf(this.val);
                }
                catch (NumberFormatException ex) {
                    throw new GenotypeDataException("Error parsing VCF info column value: " + this.val + " is not a int");
                }
            }
            case STRING: {
                if (isListValue) {
                    String[] valTokens = StringUtils.split((String)this.val, (char)',');
                    if (valTokens.length == 0) {
                        return Collections.emptyList();
                    }
                    return Arrays.asList(valTokens);
                }
                return this.val;
            }
        }
        throw new GenotypeDataException("unknown vcf info type [" + (Object)((Object)vcfMetaInfo.getType()) + "]");
    }

    public void reset(String key, String val) {
        this.key = key;
        this.val = val;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.val == null ? 0 : this.val.hashCode());
        result = 31 * result + (this.vcfMeta == null ? 0 : this.vcfMeta.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VcfInfo other = (VcfInfo)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.val == null ? other.val != null : !this.val.equals(other.val)) {
            return false;
        }
        return !(this.vcfMeta == null ? other.vcfMeta != null : !this.vcfMeta.equals(other.vcfMeta));
    }
}

