/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.genotype.Allele;
import org.molgenis.vcf.VcfInfo;
import org.molgenis.vcf.VcfSample;
import org.molgenis.vcf.meta.VcfMeta;

public class VcfRecord {
    static final String MISSING_VALUE = ".";
    private final VcfMeta vcfMeta;
    private String[] tokens;
    private transient List<String> cachedIdentifiers;
    private transient List<Allele> cachedAlternateAlleles;
    private transient String[] cachedSampleDataTypes;

    public VcfRecord(VcfMeta vcfMeta) {
        this(vcfMeta, null);
    }

    public VcfRecord(VcfMeta vcfMeta, String[] tokens) {
        if (vcfMeta == null) {
            throw new IllegalArgumentException("colNames is null");
        }
        this.vcfMeta = vcfMeta;
        this.tokens = tokens;
    }

    public String getChromosome() {
        return this.tokens[0].intern();
    }

    public int getPosition() {
        return Integer.valueOf(this.tokens[1]);
    }

    public List<String> getIdentifiers() {
        if (this.cachedIdentifiers == null) {
            String identifiersStr = this.tokens[2];
            if (identifiersStr == null || identifiersStr.equals(MISSING_VALUE)) {
                this.cachedIdentifiers = Collections.emptyList();
            } else {
                identifiersStr = new String(identifiersStr);
                this.cachedIdentifiers = Arrays.asList(StringUtils.split((String)identifiersStr, (char)';'));
            }
        }
        return this.cachedIdentifiers;
    }

    public Allele getReferenceAllele() {
        return Allele.create(this.tokens[3]);
    }

    public List<Allele> getAlternateAlleles() {
        if (this.cachedAlternateAlleles == null) {
            String alternateBasesStr = this.tokens[4];
            if (alternateBasesStr == null || alternateBasesStr.length() == 0 || alternateBasesStr.equals(MISSING_VALUE)) {
                this.cachedAlternateAlleles = Collections.emptyList();
            } else {
                this.cachedAlternateAlleles = new ArrayList<Allele>(1);
                for (String altAllele : StringUtils.split((String)alternateBasesStr, (char)',')) {
                    this.cachedAlternateAlleles.add(Allele.create(altAllele));
                }
            }
        }
        return this.cachedAlternateAlleles;
    }

    public String getQuality() {
        String quality = this.tokens[5];
        return quality != null && quality.equals(MISSING_VALUE) ? null : quality;
    }

    public String getFilterStatus() {
        String filterStatus = this.tokens[6];
        return filterStatus != null && filterStatus.equals(MISSING_VALUE) ? null : filterStatus;
    }

    public Iterable<VcfInfo> getInformation() {
        final String[] infoTokens = StringUtils.split((String)new String(this.tokens[7]), (char)';');
        return new Iterable<VcfInfo>(){

            @Override
            public Iterator<VcfInfo> iterator() {
                return new Iterator<VcfInfo>(){
                    private final VcfInfo recycableVcfInfo;
                    private int nrToken;
                    {
                        this.recycableVcfInfo = new VcfInfo(VcfRecord.this.vcfMeta);
                        this.nrToken = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nrToken < infoTokens.length;
                    }

                    @Override
                    public VcfInfo next() {
                        String infoToken;
                        int idx;
                        String key = (idx = (infoToken = infoTokens[this.nrToken++]).indexOf(61)) != -1 ? infoToken.substring(0, idx) : infoToken;
                        String val = idx != -1 ? infoToken.substring(idx + 1) : null;
                        this.recycableVcfInfo.reset(key, val);
                        return this.recycableVcfInfo;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String[] getFormat() {
        if (this.cachedSampleDataTypes == null) {
            this.cachedSampleDataTypes = this.tokens.length > 8 ? StringUtils.split((String)new String(this.tokens[8]), (char)':') : new String[0];
        }
        return this.cachedSampleDataTypes;
    }

    public int getFormatIndex(String dataType) {
        String[] dataTypes = this.getFormat();
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypes[i].equals(dataType)) continue;
            return i;
        }
        return -1;
    }

    public int getNrSamples() {
        return this.tokens.length > 9 ? this.tokens.length - 9 : 0;
    }

    public Iterable<VcfSample> getSamples() {
        final VcfRecord vcfRecord = this;
        return new Iterable<VcfSample>(){

            @Override
            public Iterator<VcfSample> iterator() {
                return new Iterator<VcfSample>(){
                    private final VcfSample recycableVcfSample;
                    private final int nrSamples;
                    private int nrSample;
                    {
                        this.recycableVcfSample = new VcfSample(vcfRecord);
                        this.nrSamples = VcfRecord.this.getNrSamples();
                        this.nrSample = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nrSample < this.nrSamples;
                    }

                    @Override
                    public VcfSample next() {
                        this.recycableVcfSample.reset(StringUtils.split((String)VcfRecord.this.tokens[9 + this.nrSample], (char)':'));
                        ++this.nrSample;
                        return this.recycableVcfSample;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void reset(String[] tokens) {
        this.tokens = tokens;
        this.cachedIdentifiers = null;
        this.cachedAlternateAlleles = null;
        this.cachedSampleDataTypes = null;
    }

    public VcfRecord createClone() {
        return new VcfRecord(this.vcfMeta, this.tokens);
    }

    public String toString() {
        return StringUtils.join((Object[])this.tokens, (char)'\t');
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.tokens);
        result = 31 * result + (this.vcfMeta == null ? 0 : this.vcfMeta.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VcfRecord other = (VcfRecord)obj;
        if (!Arrays.equals(this.tokens, other.tokens)) {
            return false;
        }
        return !(this.vcfMeta == null ? other.vcfMeta != null : !this.vcfMeta.equals(other.vcfMeta));
    }
}

