/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfRecordReader;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaParser;

public class VcfReader
implements Iterable<VcfRecord>,
Closeable {
    private final BufferedReader reader;
    private final BlockCompressedInputStream blockCompressedInputStream;
    private VcfMeta vcfMeta;

    public VcfReader(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.blockCompressedInputStream = null;
    }

    public VcfReader(BlockCompressedInputStream blockCompressedInputStream) {
        if (blockCompressedInputStream == null) {
            throw new IllegalArgumentException("blockCompressedInputStream is null");
        }
        this.blockCompressedInputStream = blockCompressedInputStream;
        this.reader = null;
    }

    @Override
    public Iterator<VcfRecord> iterator() {
        if (this.vcfMeta == null) {
            try {
                this.vcfMeta = this.parseVcfMeta();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        VcfRecordReader vcfRecordReader = this.reader != null ? new VcfRecordReader(this.reader, this.vcfMeta) : new VcfRecordReader(this.blockCompressedInputStream, this.vcfMeta);
        return vcfRecordReader.iterator();
    }

    public VcfMeta getVcfMeta() throws IOException {
        if (this.vcfMeta == null) {
            this.vcfMeta = this.parseVcfMeta();
        }
        return this.vcfMeta;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        } else if (this.blockCompressedInputStream != null) {
            this.blockCompressedInputStream.close();
        }
    }

    private VcfMeta parseVcfMeta() throws IOException {
        if (this.reader != null) {
            return new VcfMetaParser(this.reader).parse();
        }
        return new VcfMetaParser(this.blockCompressedInputStream).parse();
    }
}

