/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.vcf.meta.VcfMetaAlt;
import org.molgenis.vcf.meta.VcfMetaContig;
import org.molgenis.vcf.meta.VcfMetaFilter;
import org.molgenis.vcf.meta.VcfMetaFormat;
import org.molgenis.vcf.meta.VcfMetaInfo;
import org.molgenis.vcf.meta.VcfMetaPedigree;
import org.molgenis.vcf.meta.VcfMetaSample;

public class VcfMeta {
    private static final String KEY_FILEFORMAT = "fileformat";
    public static final int COL_CHROM_IDX = 0;
    public static final int COL_POS_IDX = 1;
    public static final int COL_ID_IDX = 2;
    public static final int COL_REF_IDX = 3;
    public static final int COL_ALT_IDX = 4;
    public static final int COL_QUAL_IDX = 5;
    public static final int COL_FILTER_IDX = 6;
    public static final int COL_INFO_IDX = 7;
    public static final int COL_FORMAT_IDX = 8;
    private final Map<String, String> meta = new LinkedHashMap<String, String>();
    private Map<String, VcfMetaAlt> vcfMetaAlts;
    private Map<String, VcfMetaContig> vcfMetaContigs;
    private Map<String, VcfMetaFilter> vcfMetaFilters;
    private Map<String, VcfMetaFormat> vcfMetaFormats;
    private Map<String, VcfMetaInfo> vcfMetaInfos;
    private Map<String, VcfMetaSample> vcfMetaSamples;
    private List<VcfMetaPedigree> vcfMetaPedigrees;
    private String[] colNames;

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public String getFileFormat() {
        return this.meta.get(KEY_FILEFORMAT);
    }

    public void add(String key, String value) {
        this.meta.put(key, value);
    }

    public String get(String key) {
        return this.meta.get(key);
    }

    public void setColNames(String[] colNames) {
        this.colNames = colNames;
    }

    public String[] getColNames() {
        return this.colNames;
    }

    public String getSampleName(int nr) {
        return this.colNames[9 + nr];
    }

    public Iterable<String> getSampleNames() {
        if (this.colNames.length <= 8) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.colNames).subList(9, this.colNames.length);
    }

    public void addAltMeta(VcfMetaAlt vcfMetaAlt) {
        if (this.vcfMetaAlts == null) {
            this.vcfMetaAlts = new LinkedHashMap<String, VcfMetaAlt>();
        }
        this.vcfMetaAlts.put(vcfMetaAlt.getId(), vcfMetaAlt);
    }

    public Iterable<VcfMetaAlt> getAltMeta() {
        return this.vcfMetaAlts != null ? this.vcfMetaAlts.values() : Collections.emptyList();
    }

    public VcfMetaAlt getAltMeta(String id) {
        return this.vcfMetaAlts != null ? this.vcfMetaAlts.get(id) : null;
    }

    public void addContigMeta(VcfMetaContig vcfMetaContig) {
        if (this.vcfMetaContigs == null) {
            this.vcfMetaContigs = new LinkedHashMap<String, VcfMetaContig>();
        }
        this.vcfMetaContigs.put(vcfMetaContig.getId(), vcfMetaContig);
    }

    public Iterable<VcfMetaContig> getContigMeta() {
        return this.vcfMetaContigs != null ? this.vcfMetaContigs.values() : Collections.emptyList();
    }

    public VcfMetaContig getContigMeta(String id) {
        return this.vcfMetaContigs != null ? this.vcfMetaContigs.get(id) : null;
    }

    public void addFilterMeta(VcfMetaFilter vcfMetaFilter) {
        if (this.vcfMetaFilters == null) {
            this.vcfMetaFilters = new LinkedHashMap<String, VcfMetaFilter>();
        }
        this.vcfMetaFilters.put(vcfMetaFilter.getId(), vcfMetaFilter);
    }

    public Iterable<VcfMetaFilter> getFilterMeta() {
        return this.vcfMetaFilters != null ? this.vcfMetaFilters.values() : Collections.emptyList();
    }

    public VcfMetaFilter getFilterMeta(String id) {
        return this.vcfMetaFilters != null ? this.vcfMetaFilters.get(id) : null;
    }

    public void addFormatMeta(VcfMetaFormat vcfMetaFormat) {
        if (this.vcfMetaFormats == null) {
            this.vcfMetaFormats = new LinkedHashMap<String, VcfMetaFormat>();
        }
        this.vcfMetaFormats.put(vcfMetaFormat.getId(), vcfMetaFormat);
    }

    public Iterable<VcfMetaFormat> getFormatMeta() {
        return this.vcfMetaFormats != null ? this.vcfMetaFormats.values() : Collections.emptyList();
    }

    public VcfMetaFormat getFormatMeta(String id) {
        return this.vcfMetaFormats != null ? this.vcfMetaFormats.get(id) : null;
    }

    public void addInfoMeta(VcfMetaInfo vcfMetaInfo) {
        if (this.vcfMetaInfos == null) {
            this.vcfMetaInfos = new LinkedHashMap<String, VcfMetaInfo>();
        }
        this.vcfMetaInfos.put(vcfMetaInfo.getId(), vcfMetaInfo);
    }

    public Iterable<VcfMetaInfo> getInfoMeta() {
        return this.vcfMetaInfos != null ? this.vcfMetaInfos.values() : Collections.emptyList();
    }

    public VcfMetaInfo getInfoMeta(String id) {
        return this.vcfMetaInfos != null ? this.vcfMetaInfos.get(id) : null;
    }

    public void addPedigreeMeta(VcfMetaPedigree vcfMetaPedigree) {
        if (this.vcfMetaPedigrees == null) {
            this.vcfMetaPedigrees = new ArrayList<VcfMetaPedigree>();
        }
        this.vcfMetaPedigrees.add(vcfMetaPedigree);
    }

    public Iterable<VcfMetaPedigree> getPedigreeMeta() {
        return this.vcfMetaPedigrees != null ? this.vcfMetaPedigrees : Collections.emptyList();
    }

    public void setVcfMetaSamples(Map<String, VcfMetaSample> vcfMetaSamples) {
        this.vcfMetaSamples = vcfMetaSamples;
    }

    public void addSampleMeta(VcfMetaSample vcfMetaSample) {
        if (this.vcfMetaSamples == null) {
            this.vcfMetaSamples = new LinkedHashMap<String, VcfMetaSample>();
        }
        this.vcfMetaSamples.put(vcfMetaSample.getId(), vcfMetaSample);
    }

    public Iterable<VcfMetaSample> getSampleMeta() {
        return this.vcfMetaSamples != null ? this.vcfMetaSamples.values() : Collections.emptyList();
    }

    public VcfMetaSample getSampleMeta(String id) {
        return this.vcfMetaSamples != null ? this.vcfMetaSamples.get(id) : null;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.meta.entrySet()) {
            strBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        if (this.vcfMetaAlts != null) {
            for (VcfMetaAlt vcfMetaAlt : this.vcfMetaAlts.values()) {
                strBuilder.append(vcfMetaAlt);
            }
        }
        if (this.vcfMetaContigs != null) {
            for (VcfMetaContig vcfMetaContig : this.vcfMetaContigs.values()) {
                strBuilder.append(vcfMetaContig);
            }
        }
        if (this.vcfMetaFilters != null) {
            for (VcfMetaFilter vcfMetaFilter : this.vcfMetaFilters.values()) {
                strBuilder.append(vcfMetaFilter);
            }
        }
        if (this.vcfMetaFormats != null) {
            for (VcfMetaFormat vcfMetaFormat : this.vcfMetaFormats.values()) {
                strBuilder.append(vcfMetaFormat);
            }
        }
        if (this.vcfMetaInfos != null) {
            for (VcfMetaInfo vcfMetaInfo : this.vcfMetaInfos.values()) {
                strBuilder.append(vcfMetaInfo);
            }
        }
        if (this.vcfMetaSamples != null) {
            for (VcfMetaSample vcfMetaSample : this.vcfMetaSamples.values()) {
                strBuilder.append(vcfMetaSample);
            }
        }
        if (this.vcfMetaPedigrees != null) {
            for (VcfMetaPedigree vcfMetaPedigree : this.vcfMetaPedigrees) {
                strBuilder.append(vcfMetaPedigree);
            }
        }
        return strBuilder.toString();
    }
}

