/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.v4_2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfWriter;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.v4_2.Vcf42MetaWriter;

public class Vcf42Writer
implements VcfWriter {
    private final Writer writer;
    private final VcfMeta vcfMeta;
    private boolean writeVcfMeta = false;

    public Vcf42Writer(OutputStream outputStream, VcfMeta vcfMeta) {
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.vcfMeta = Objects.requireNonNull(vcfMeta);
    }

    @Override
    public void write(VcfRecord vcfRecord) throws IOException {
        if (!this.writeVcfMeta) {
            this.writeVcfMeta();
        }
        this.writeVcfRecord(vcfRecord);
    }

    private void writeVcfMeta() throws IOException {
        new Vcf42MetaWriter(this.writer).write(this.vcfMeta);
        this.writeVcfColumnHeader();
        this.writeVcfMeta = true;
    }

    private void writeVcfColumnHeader() throws IOException {
        String[] colNames = this.vcfMeta.getColNames();
        for (int i = 0; i < colNames.length; ++i) {
            if (i > 0) {
                this.writer.write(9);
            }
            this.writer.write(colNames[i]);
        }
        this.writer.write(10);
    }

    private void writeVcfRecord(VcfRecord vcfRecord) throws IOException {
        String[] tokens = vcfRecord.getTokens();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                this.writer.write(9);
            }
            this.writer.write(tokens[i]);
        }
        this.writer.write(10);
    }

    @Override
    public void close() throws Exception {
        if (!this.writeVcfMeta) {
            this.writeVcfMeta();
        }
        this.writer.close();
    }
}

