/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.rw.XMLResults;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.resultset.ResultSetApply;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.ResultSetProcessor;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class ResultSetWriterXML
implements ResultSetWriter {
    public static final Symbol xmlInstruction = SystemARQ.allocSymbol("xmlInstruction");
    public static final Symbol xmlStylesheet = SystemARQ.allocSymbol("xmlStylesheet");
    public static ResultSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.SPARQLResultSetXML)) {
            throw new ResultSetException("ResultSetWriter for XML asked for a " + lang);
        }
        return new ResultSetWriterXML();
    };

    private ResultSetWriterXML() {
    }

    @Override
    public void write(Writer out, ResultSet resultSet, Context context2) {
        throw new UnsupportedOperationException("Writing XML results to a java.io.Writer. Use an OutputStream.");
    }

    @Override
    public void write(OutputStream outStream, boolean result, Context context2) {
        XMLOutputASK out = new XMLOutputASK(outStream);
        if (context2 != null && context2.isDefined(xmlInstruction)) {
            out.xmlInst = context2.isTrue(xmlInstruction);
        }
        if (context2 != null && context2.isDefined(xmlStylesheet)) {
            out.stylesheetURL = (String)context2.get(xmlStylesheet);
        }
        out.exec(result);
    }

    @Override
    public void write(OutputStream outStream, ResultSet resultSet, Context context2) {
        XMLOutputResultSet xOut = new XMLOutputResultSet(outStream, context2);
        if (context2 != null && context2.isDefined(xmlInstruction)) {
            xOut.setXmlInst(context2.isTrue(xmlInstruction));
        }
        if (context2 != null && context2.isDefined(xmlStylesheet)) {
            xOut.setStylesheetURL((String)context2.get(xmlStylesheet));
        }
        ResultSetApply a = new ResultSetApply(resultSet, xOut);
        a.apply();
    }

    private static class XMLOutputResultSet
    implements ResultSetProcessor,
    XMLResults {
        private static boolean outputExplicitUnbound = false;
        private int index = 0;
        private String stylesheetURL = null;
        private boolean xmlInst = true;
        private final IndentedWriter out;
        private int bNodeCounter = 0;
        private final NodeToLabel bNodeMap;

        private XMLOutputResultSet(OutputStream outStream, Context context2) {
            this(new IndentedWriter(outStream), context2);
        }

        private XMLOutputResultSet(IndentedWriter indentedOut, Context context2) {
            this.out = indentedOut;
            boolean outputGraphBNodeLabels = context2 != null && context2.isTrue(ARQ.outputGraphBNodeLabels);
            this.bNodeMap = outputGraphBNodeLabels ? SyntaxLabels.createNodeToLabelAsGiven() : SyntaxLabels.createNodeToLabel();
        }

        @Override
        public void start(ResultSet rs) {
            if (this.xmlInst) {
                this.out.println("<?xml version=\"1.0\"?>");
            }
            if (this.stylesheetURL != null) {
                this.out.print("<?xml-stylesheet type=\"text/xsl\" href=\"");
                this.out.print(this.stylesheetURL);
                this.out.println("\"?>");
            }
            this.out.print("<");
            this.out.print("sparql");
            this.out.print(" xmlns=\"");
            this.out.print("http://www.w3.org/2005/sparql-results#");
            this.out.println("\">");
            this.out.incIndent(2);
            this.out.print("<");
            this.out.print("head");
            this.out.println(">");
            for (String n : rs.getResultVars()) {
                this.out.incIndent(2);
                this.out.print("<");
                this.out.print("variable");
                this.out.print(" ");
                this.out.print("name");
                this.out.print("=\"");
                this.out.print(n);
                this.out.print("\"");
                this.out.println("/>");
                this.out.decIndent(2);
            }
            this.out.print("</");
            this.out.print("head");
            this.out.println(">");
            this.out.decIndent(2);
            this.out.incIndent(2);
            this.out.print("<");
            this.out.print("results");
            this.out.println(">");
            this.out.incIndent(2);
        }

        @Override
        public void finish(ResultSet rs) {
            this.out.decIndent(2);
            this.out.print("</");
            this.out.print("results");
            this.out.println(">");
            this.out.decIndent(2);
            this.out.print("</");
            this.out.print("sparql");
            this.out.println(">");
            this.out.flush();
        }

        @Override
        public void start(QuerySolution qs) {
            this.out.print("<");
            this.out.print("result");
            this.out.println(">");
            ++this.index;
            this.out.incIndent(2);
        }

        @Override
        public void finish(QuerySolution qs) {
            this.out.decIndent(2);
            this.out.print("</");
            this.out.print("result");
            this.out.println(">");
        }

        @Override
        public void binding(String varName, RDFNode node) {
            if (node == null && !outputExplicitUnbound) {
                return;
            }
            this.out.print("<");
            this.out.print("binding");
            this.out.print(" name=\"");
            this.out.print(varName);
            this.out.println("\">");
            this.out.incIndent(2);
            this.printBindingValue(node);
            this.out.decIndent(2);
            this.out.print("</");
            this.out.print("binding");
            this.out.println(">");
        }

        void printBindingValue(RDFNode node) {
            if (node == null) {
                this.out.print("<");
                this.out.print("unbound");
                this.out.println("/>");
                return;
            }
            if (node instanceof Literal) {
                this.printLiteral((Literal)node);
                return;
            }
            if (node instanceof Resource) {
                this.printResource((Resource)node);
                return;
            }
            Log.warn(this, "Unknown RDFNode type in result set: " + node.getClass());
        }

        void printLiteral(Literal literal) {
            this.out.print("<");
            this.out.print("literal");
            if (Util.isLangString(literal)) {
                String lang = literal.getLanguage();
                this.out.print(" xml:lang=\"");
                this.out.print(literal.getLanguage());
                this.out.print("\"");
            } else if (!Util.isSimpleString(literal)) {
                String datatype = literal.getDatatypeURI();
                this.out.print(" ");
                this.out.print("datatype");
                this.out.print("=\"");
                this.out.print(datatype);
                this.out.print("\"");
            }
            this.out.print(">");
            this.out.print(XMLOutputResultSet.xml_escape(literal.getLexicalForm()));
            this.out.print("</");
            this.out.print("literal");
            this.out.println(">");
        }

        void printResource(Resource r) {
            if (r.isAnon()) {
                String label = (String)this.bNodeMap.get(null, r.asNode());
                label = label.substring(2);
                this.out.print("<");
                this.out.print("bnode");
                this.out.print(">");
                this.out.print(XMLOutputResultSet.xml_escape(label));
                this.out.print("</");
                this.out.print("bnode");
                this.out.println(">");
            } else {
                this.out.print("<");
                this.out.print("uri");
                this.out.print(">");
                this.out.print(XMLOutputResultSet.xml_escape(r.getURI()));
                this.out.print("</");
                this.out.print("uri");
                this.out.println(">");
            }
        }

        private static String xml_escape(String string) {
            StringBuilder sb = new StringBuilder(string);
            int offset = 0;
            for (int i = 0; i < string.length(); ++i) {
                String replacement;
                char found = string.charAt(i);
                switch (found) {
                    case '&': {
                        replacement = "&amp;";
                        break;
                    }
                    case '<': {
                        replacement = "&lt;";
                        break;
                    }
                    case '>': {
                        replacement = "&gt;";
                        break;
                    }
                    case '\r': {
                        replacement = "&#x0D;";
                        break;
                    }
                    case '\n': {
                        replacement = "&#x0A;";
                        break;
                    }
                    default: {
                        replacement = null;
                    }
                }
                if (replacement == null) continue;
                sb.replace(offset + i, offset + i + 1, replacement);
                offset += replacement.length() - 1;
            }
            return sb.toString();
        }

        public String getStylesheetURL() {
            return this.stylesheetURL;
        }

        public void setStylesheetURL(String stylesheetURL) {
            this.stylesheetURL = stylesheetURL;
        }

        public boolean getXmlInst() {
            return this.xmlInst;
        }

        public void setXmlInst(boolean xmlInst) {
            this.xmlInst = xmlInst;
        }
    }

    private class XMLOutputASK
    implements XMLResults {
        String stylesheetURL = null;
        IndentedWriter out;
        int bNodeCounter = 0;
        boolean xmlInst = true;

        public XMLOutputASK(OutputStream outStream) {
            this(outStream, null);
        }

        public XMLOutputASK(OutputStream outStream, String stylesheetURL) {
            this(new IndentedWriter(outStream), stylesheetURL);
        }

        public XMLOutputASK(IndentedWriter indentedOut, String stylesheetURL) {
            this.out = indentedOut;
            this.stylesheetURL = stylesheetURL;
        }

        public void exec(boolean result) {
            if (this.xmlInst) {
                this.out.println("<?xml version=\"1.0\"?>");
            }
            if (this.stylesheetURL != null) {
                this.out.println("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.stylesheetURL + "\"?>");
            }
            this.out.println("<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\">");
            this.out.incIndent(2);
            this.out.println("<head>");
            this.out.incIndent(2);
            this.out.decIndent(2);
            this.out.println("</head>");
            if (result) {
                this.out.println("<boolean>true</boolean>");
            } else {
                this.out.println("<boolean>false</boolean>");
            }
            this.out.decIndent(2);
            this.out.println("</sparql>");
            this.out.flush();
        }
    }
}

