/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ReportConstraint;
import org.apache.jena.shacl.lib.G;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ValidationProc;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class QualifiedValueShape
implements Constraint {
    private final Shape sub;
    private int qMin;
    private int qMax;
    private boolean qDisjoint;

    public QualifiedValueShape(Shape sub, int qMin, int qMax, boolean qDisjoint) {
        this.sub = sub;
        this.qMin = qMin;
        this.qMax = qMax;
        this.qDisjoint = qDisjoint;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        throw new ShaclException("sh:qualifiedValueShape only valid in a property shape");
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> valueNodes) {
        Set<Node> valueNodes2;
        Collection<Node> sibs = this.siblings(vCxt.getShapesGraph(), shape);
        if (this.qDisjoint) {
            valueNodes2 = new HashSet<Node>();
            for (Node node : valueNodes) {
                if (this.conformsSiblings(vCxt, node, sibs)) continue;
                valueNodes2.add(node);
            }
        } else {
            valueNodes2 = valueNodes;
        }
        int x = 0;
        for (Node v : valueNodes2) {
            boolean b = QualifiedValueShape.conforms(vCxt, this.sub, v);
            if (!b) continue;
            ++x;
        }
        if (this.qMin >= 0 && this.qMin > x) {
            String string = this.toString() + ": Min = " + this.qMin + " but got " + x + " validations";
            vCxt.reportEntry(string, shape, focusNode, path, null, new ReportConstraint(SHACL.QualifiedMinCountConstraintComponent));
        }
        if (this.qMax >= 0 && this.qMax < x) {
            String string = this.toString() + ": Max = " + this.qMax + " but got " + x + " validations";
            vCxt.reportEntry(string, shape, focusNode, path, null, new ReportConstraint(SHACL.QualifiedMaxCountConstraintComponent));
        }
    }

    private boolean conformsSiblings(ValidationContext vCxt, Node v, Collection<Node> sibs) {
        for (Node sib : sibs) {
            Shape sibShape = vCxt.getShapes().getShape(sib);
            boolean b = QualifiedValueShape.conforms(vCxt, sibShape, v);
            if (!b) continue;
            return true;
        }
        return false;
    }

    private static boolean conforms(ValidationContext vCxt, Shape shape, Node v) {
        ValidationContext vCxt2 = new ValidationContext(vCxt);
        vCxt2.setVerbose(false);
        ValidationProc.execValidateShape(vCxt2, vCxt.getDataGraph(), shape, v);
        ValidationReport report = vCxt2.generateReport();
        return report.conforms();
    }

    private Collection<Node> siblings(Graph shapesGraph, Shape thisShape) {
        if (!this.qDisjoint) {
            return Collections.emptySet();
        }
        Node thisShapeNode = thisShape.getShapeNode();
        HashSet sibs = new HashSet();
        List<Node> parents = G.listPO(shapesGraph, SHACL.property, thisShapeNode);
        parents.forEach(s -> {
            List<Node> sibs1 = G.listSP(shapesGraph, s, SHACL.property);
            sibs.addAll(sibs1);
        });
        HashSet<Node> sibShapes = new HashSet<Node>();
        sibs.forEach(s -> {
            List<Node> x = G.listSP(shapesGraph, s, SHACL.qualifiedValueShape);
            sibShapes.addAll(x);
        });
        sibShapes.remove(this.sub.getShapeNode());
        return sibShapes;
    }

    @Override
    public Node getComponent() {
        return SHACL.qualifiedValueShape;
    }

    public String toString() {
        return String.format("QualifiedValueShape[%s,%s,%s]", this.qMin < 0 ? "_" : Integer.toString(this.qMin), this.qMax < 0 ? "_" : Integer.toString(this.qMax), this.qDisjoint);
    }
}

