/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.engine.http.Params;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.engine.http.Service;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.web.HttpSC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpQuery
extends Params {
    static final Logger log = LoggerFactory.getLogger(HttpQuery.class.getName());
    public static int urlLimit = 2048;
    String serviceURL;
    String contentTypeResult = "application/sparql-results+xml";
    static final Object noValue = new Object();
    private int responseCode = 0;
    private String responseMessage = null;
    private boolean forcePOST = false;
    private String queryString = null;
    private boolean serviceParams = false;
    private final Pattern queryParamPattern = Pattern.compile(".+[&|\\?]query=.*");
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private boolean allowCompression = false;
    private HttpClient client;
    private HttpContext context;

    public HttpQuery(String serviceURL) {
        this.init(serviceURL);
    }

    public HttpQuery(URL url) {
        this.init(url.toString());
    }

    private void init(String serviceURL) {
        if (log.isTraceEnabled()) {
            log.trace("URL: " + serviceURL);
        }
        if (serviceURL.indexOf(63) >= 0) {
            this.serviceParams = true;
        }
        if (this.queryParamPattern.matcher(serviceURL).matches()) {
            throw new QueryExecException("SERVICE URL overrides the 'query' SPARQL protocol parameter");
        }
        this.serviceURL = serviceURL;
    }

    private String getQueryString() {
        if (this.queryString == null) {
            this.queryString = super.httpString();
        }
        return this.queryString;
    }

    public void setAccept(String contentType) {
        this.contentTypeResult = contentType;
    }

    public String getContentType() {
        return this.contentTypeResult;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setAllowCompression(boolean allow) {
        this.allowCompression = allow;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public void setContext(HttpContext context2) {
        this.context = context2;
    }

    public HttpClient getClient() {
        Context serviceContext;
        Map context2;
        Context arqContext = ARQ.getContext();
        if (arqContext.isDefined(Service.serviceContext) && (context2 = (Map)arqContext.get(Service.serviceContext)).containsKey(this.serviceURL) && (serviceContext = (Context)context2.get(this.serviceURL)).isDefined(Service.queryClient)) {
            return (HttpClient)serviceContext.get(Service.queryClient);
        }
        return this.client;
    }

    public HttpContext getContext() {
        if (this.context == null) {
            this.context = new BasicHttpContext();
        }
        return this.context;
    }

    public boolean usesPOST() {
        if (this.forcePOST) {
            return true;
        }
        String s = this.getQueryString();
        return this.serviceURL.length() + s.length() >= urlLimit;
    }

    public void setForcePOST() {
        this.forcePOST = true;
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public InputStream exec() throws QueryExceptionHTTP {
        HttpClientContext hcc = HttpClientContext.adapt(this.getContext());
        RequestConfig.Builder builder = RequestConfig.copy(hcc.getRequestConfig());
        this.contextualizeCompressionSettings(builder);
        this.contextualizeTimeoutSettings(builder);
        hcc.setRequestConfig(builder.build());
        try {
            if (this.usesPOST()) {
                return this.execPost();
            }
            return this.execGet();
        }
        catch (QueryExceptionHTTP httpEx) {
            log.trace("Exception in exec", httpEx);
            throw httpEx;
        }
        catch (JenaException jEx) {
            log.trace("JenaException in exec", jEx);
            throw jEx;
        }
    }

    private void contextualizeCompressionSettings(RequestConfig.Builder builder) {
        builder.setContentCompressionEnabled(this.allowCompression);
    }

    private void contextualizeTimeoutSettings(RequestConfig.Builder builder) {
        if (this.connectTimeout > 0) {
            builder.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            builder.setSocketTimeout(this.readTimeout);
        }
    }

    private InputStream execGet() throws QueryExceptionHTTP {
        URL target = null;
        String qs = this.getQueryString();
        ARQ.getHttpRequestLogger().trace(qs);
        try {
            target = this.count() == 0 ? new URL(this.serviceURL) : new URL(this.serviceURL + (this.serviceParams ? "&" : "?") + qs);
        }
        catch (MalformedURLException malEx) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malEx);
        }
        log.trace("GET " + target.toExternalForm());
        try {
            TypedInputStream stream = HttpQuery.execHttpGet(target.toString(), this.contentTypeResult, this.client, this.getContext());
            if (stream == null) {
                throw new QueryExceptionHTTP(404, HttpSC.getMessage(404));
            }
            return this.execCommon(stream);
        }
        catch (HttpException httpEx) {
            try {
                if (httpEx.getStatusCode() == 414) {
                    return this.execPost();
                }
                throw httpEx;
            }
            catch (HttpException httpEx2) {
                throw this.rewrap(httpEx2);
            }
        }
    }

    private static TypedInputStream execHttpGet(String url, String acceptHeader, HttpClient httpClient, HttpContext httpContext) {
        HttpOp.CaptureInput handler = new HttpOp.CaptureInput();
        HttpOp.execHttpGet(url, acceptHeader, handler, httpClient, httpContext);
        return (TypedInputStream)handler.get();
    }

    private InputStream execPost() throws QueryExceptionHTTP {
        URL target = null;
        try {
            target = new URL(this.serviceURL);
        }
        catch (MalformedURLException malEx) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malEx);
        }
        log.trace("POST " + target.toExternalForm());
        ARQ.getHttpRequestLogger().trace(target.toExternalForm());
        try {
            TypedInputStream stream = HttpOp.execHttpPostFormStream(this.serviceURL, this, this.contentTypeResult, this.client, this.getContext());
            if (stream == null) {
                throw new QueryExceptionHTTP(404);
            }
            return this.execCommon(stream);
        }
        catch (HttpException httpEx) {
            throw this.rewrap(httpEx);
        }
    }

    private QueryExceptionHTTP rewrap(HttpException httpEx) {
        this.responseCode = httpEx.getStatusCode();
        if (this.responseCode != -1) {
            String responseLine = httpEx.getStatusLine() != null ? httpEx.getStatusLine() : "No Status Line";
            return new QueryExceptionHTTP(this.responseCode, responseLine, httpEx);
        }
        if (httpEx.getMessage() != null) {
            return new QueryExceptionHTTP(this.responseCode, "Unexpected error making the query: " + httpEx.getMessage(), httpEx);
        }
        if (httpEx.getCause() != null) {
            return new QueryExceptionHTTP(this.responseCode, "Unexpected error making the query, see cause for further details", httpEx);
        }
        return new QueryExceptionHTTP(this.responseCode, "Unexpected error making the query", httpEx);
    }

    private InputStream execCommon(TypedInputStream stream) throws QueryExceptionHTTP {
        this.responseCode = 200;
        this.responseMessage = "OK";
        this.contentTypeResult = stream.getContentType();
        if (this.contentTypeResult != null && this.contentTypeResult.contains(";")) {
            this.contentTypeResult = this.contentTypeResult.substring(0, this.contentTypeResult.indexOf(59));
        }
        return stream;
    }

    public String toString() {
        String s = this.httpString();
        if (s != null && s.length() > 0) {
            return this.serviceURL + "?" + s;
        }
        return this.serviceURL;
    }
}

