/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.index;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.index.IndexTable;

public class SetIndexTable
implements IndexTable {
    private Var var;
    private Set<Node> values = new HashSet<Node>();

    public SetIndexTable(Set<Var> commonVars, QueryIterator data) {
        if (commonVars.size() != 1) {
            throw new IllegalArgumentException("Common Variables must be of size 1");
        }
        this.var = commonVars.iterator().next();
        while (data.hasNext()) {
            Binding binding = (Binding)data.next();
            Node value = binding.get(this.var);
            if (value == null) continue;
            this.values.add(value);
        }
    }

    @Override
    public boolean containsCompatibleWithSharedDomain(Binding binding) {
        Node value = binding.get(this.var);
        if (value == null) {
            return false;
        }
        return this.values.contains(value);
    }

    public String toString() {
        return "SetIndexTable: " + this.var + " " + this.values;
    }
}

