/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.path;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterYieldN;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_Path1;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathPropertyFunction;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.util.iterator.ExtendedIterator;

public class PathLib {
    public static Op pathToTriples(PathBlock pattern) {
        BasicPattern bp = null;
        Op op = null;
        for (TriplePath tp : pattern) {
            if (tp.isTriple()) {
                if (bp == null) {
                    bp = new BasicPattern();
                }
                bp.add(tp.asTriple());
                continue;
            }
            op = PathLib.flush(bp, op);
            bp = null;
            OpPath opPath2 = new OpPath(tp);
            op = OpSequence.create(op, opPath2);
        }
        op = PathLib.flush(bp, op);
        return op;
    }

    private static Op flush(BasicPattern bp, Op op) {
        if (bp == null || bp.isEmpty()) {
            return op;
        }
        OpBGP opBGP = new OpBGP(bp);
        op = OpSequence.create(op, opBGP);
        return op;
    }

    public static void install(String uri, Path path) {
        PathLib.install(uri, path, PropertyFunctionRegistry.get());
    }

    public static void install(String uri, Path path, PropertyFunctionRegistry registry) {
        PropertyFunctionFactory pathPropFuncFactory = u -> new PathPropertyFunction(path);
        registry.put(uri, pathPropFuncFactory);
    }

    public static QueryIterator execTriplePath(Binding binding, TriplePath triplePath, ExecutionContext execCxt) {
        if (triplePath.isTriple()) {
            P_Link path = new P_Link(triplePath.getPredicate());
            triplePath = new TriplePath(triplePath.getSubject(), path, triplePath.getObject());
        }
        return PathLib.execTriplePath(binding, triplePath.getSubject(), triplePath.getPath(), triplePath.getObject(), execCxt);
    }

    public static QueryIterator execTriplePath(Binding binding, Node s, Path path, Node o, ExecutionContext execCxt) {
        Explain.explain(s, path, o, execCxt.getContext());
        s = Var.lookup(binding, s);
        o = Var.lookup(binding, o);
        Iterator<Node> iter = null;
        Node endNode = null;
        Graph graph = execCxt.getActiveGraph();
        if (Var.isVar(s) && Var.isVar(o)) {
            if (s.equals(o)) {
                return PathLib.execUngroundedPathSameVar(binding, graph, Var.alloc(s), path, execCxt);
            }
            return PathLib.execUngroundedPath(binding, graph, Var.alloc(s), path, Var.alloc(o), execCxt);
        }
        if (!Var.isVar(s) && !Var.isVar(o)) {
            return PathLib.evalGroundedPath(binding, graph, s, path, o, execCxt);
        }
        if (Var.isVar(s)) {
            iter = PathEval.evalReverse(graph, o, path, execCxt.getContext());
            endNode = s;
        } else {
            iter = PathEval.eval(graph, s, path, execCxt.getContext());
            endNode = o;
        }
        return PathLib.evalGroundedOneEnd(binding, iter, endNode, execCxt);
    }

    private static QueryIterator evalGroundedOneEnd(Binding binding, Iterator<Node> iter, Node endNode, ExecutionContext execCxt) {
        ArrayList<Binding> results = new ArrayList<Binding>();
        if (!Var.isVar(endNode)) {
            throw new ARQInternalErrorException("Non-variable endnode in _execTriplePath");
        }
        Var var = Var.alloc(endNode);
        while (iter.hasNext()) {
            Node n = iter.next();
            results.add(BindingFactory.binding(binding, var, n));
        }
        return new QueryIterPlainWrapper(results.iterator(), execCxt);
    }

    private static QueryIterator evalGroundedPath(Binding binding, Graph graph, Node subject, Path path, Node object, ExecutionContext execCxt) {
        Iterator<Node> iter = PathEval.eval(graph, subject, path, execCxt.getContext());
        int count = 0;
        while (iter.hasNext()) {
            Node n = iter.next();
            if (!n.sameValueAs(object)) continue;
            ++count;
        }
        return new QueryIterYieldN(count, binding, execCxt);
    }

    private static QueryIterator execUngroundedPath(Binding binding, Graph graph, Var sVar, Path path, Var oVar, ExecutionContext execCxt) {
        Iterator<Node> iter = PathLib.determineUngroundedStartingSet(graph, path, execCxt);
        QueryIterConcat qIterCat = new QueryIterConcat(execCxt);
        while (iter.hasNext()) {
            Node n = iter.next();
            Binding b2 = BindingFactory.binding(binding, sVar, n);
            Iterator<Node> pathIter = PathEval.eval(graph, n, path, execCxt.getContext());
            QueryIterator qIter = PathLib.evalGroundedOneEnd(b2, pathIter, oVar, execCxt);
            qIterCat.add(qIter);
        }
        return qIterCat;
    }

    private static QueryIterator execUngroundedPathSameVar(Binding binding, Graph graph, Var var, Path path, ExecutionContext execCxt) {
        Iterator<Node> iter = PathLib.determineUngroundedStartingSet(graph, path, execCxt);
        QueryIterConcat qIterCat = new QueryIterConcat(execCxt);
        while (iter.hasNext()) {
            Node n = iter.next();
            Binding b2 = BindingFactory.binding(binding, var, n);
            int x = PathLib.existsPath(graph, n, path, n, execCxt);
            if (x <= 0) continue;
            QueryIterYieldN qIter = new QueryIterYieldN(x, b2, execCxt);
            qIterCat.add(qIter);
        }
        return qIterCat;
    }

    private static Iterator<Node> determineUngroundedStartingSet(Graph graph, Path path, ExecutionContext execCxt) {
        if (path instanceof P_OneOrMore1 || path instanceof P_OneOrMoreN) {
            P_Link link;
            P_Inverse pInv;
            Path subPath = ((P_Path1)path).getSubPath();
            if (subPath instanceof P_Link) {
                P_Link link2 = (P_Link)subPath;
                if (!PathLib.isPropertyFunction(link2.getNode(), execCxt.getContext())) {
                    ExtendedIterator<Triple> sIter = graph.find(null, link2.getNode(), null);
                    return Iter.iter(sIter).distinctAdjacent().map(Triple::getSubject).distinct();
                }
            } else if (subPath instanceof P_Inverse && (pInv = (P_Inverse)subPath).getSubPath() instanceof P_Link && !PathLib.isPropertyFunction((link = (P_Link)pInv.getSubPath()).getNode(), execCxt.getContext())) {
                ExtendedIterator<Triple> sIter = graph.find(null, link.getNode(), null);
                return Iter.iter(sIter).distinctAdjacent().map(Triple::getObject).distinct();
            }
        }
        return GraphUtils.allNodes(graph);
    }

    private static boolean isPropertyFunction(Node node, Context context2) {
        if (!node.isURI()) {
            return false;
        }
        return PropertyFunctionRegistry.chooseRegistry(context2).isRegistered(node.getURI());
    }

    private static int existsPath(Graph graph, Node subject, Path path, Node object, ExecutionContext execCxt) {
        if (!subject.isConcrete() || !object.isConcrete()) {
            throw new ARQInternalErrorException("Non concrete node for existsPath evaluation");
        }
        Iterator<Node> iter = PathEval.eval(graph, subject, path, execCxt.getContext());
        Predicate<Node> filter = node -> Objects.equals(node, object);
        iter = Iter.filter(iter, filter);
        long x = Iter.count(iter);
        return (int)x;
    }
}

