/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.file;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;

public abstract class PlainFile
implements Sync,
Closeable {
    protected long filesize = -1L;
    protected ByteBuffer byteBuffer = null;

    PlainFile() {
    }

    public final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public final ByteBuffer ensure(int newSize) {
        if (this.filesize > (long)newSize) {
            return this.getByteBuffer();
        }
        this.byteBuffer = this.allocateBuffer(newSize);
        this.filesize = newSize;
        return this.byteBuffer;
    }

    public final long getFileSize() {
        return this.filesize;
    }

    @Override
    public abstract void sync();

    @Override
    public abstract void close();

    protected abstract ByteBuffer allocateBuffer(long var1);
}

