/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.cli;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.jena.ext.com.google.common.base.Stopwatch;
import org.molgenis.vibe.cli.io.options_digestion.CommandLineOptionsParser;
import org.molgenis.vibe.cli.io.options_digestion.VibeOptions;
import org.molgenis.vibe.cli.properties.VibeProperties;
import org.molgenis.vibe.core.GeneDiseaseCollectionRetrievalRunner;
import org.molgenis.vibe.core.PhenotypesRetrievalRunner;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.formats.PhenotypeNetworkCollection;
import org.molgenis.vibe.core.query_output_digestion.prioritization.gene.HighestSingleDisgenetScoreGenePrioritizer;

public enum RunMode {
    HELP("Show help message."){

        @Override
        protected void runMode(VibeOptions vibeOptions, Stopwatch stopwatch) {
            CommandLineOptionsParser.printHelpMessage();
        }
    }
    ,
    VERSION("Show application version."){

        @Override
        protected void runMode(VibeOptions vibeOptions, Stopwatch stopwatch) {
            System.out.println(VibeProperties.APP_VERSION.getValue());
        }
    }
    ,
    GENES_FOR_PHENOTYPES_WITH_ASSOCIATED_PHENOTYPES("Retrieves genes for input phenotypes and phenotypes associated to input phenotypes."){

        @Override
        protected void runMode(VibeOptions vibeOptions, Stopwatch stopwatch) throws IOException {
            PhenotypeNetworkCollection phenotypeNetworkCollection = this.retrieveAssociatedPhenotypes(vibeOptions, stopwatch);
            GeneDiseaseCollection geneDiseaseCollection = RunMode.retrieveDisgenetData(vibeOptions, stopwatch, phenotypeNetworkCollection.getPhenotypes());
            List genePriority = RunMode.orderGenes(vibeOptions, stopwatch, geneDiseaseCollection);
            RunMode.writePrioritizedGenesOutput(vibeOptions, stopwatch, geneDiseaseCollection, genePriority);
        }

        private PhenotypeNetworkCollection retrieveAssociatedPhenotypes(VibeOptions vibeOptions, Stopwatch stopwatch) {
            vibeOptions.printVerbose("# " + vibeOptions.getPhenotypesRetrieverFactory().getDescription());
            RunMode.resetTimer(stopwatch);
            PhenotypeNetworkCollection phenotypeNetworkCollection = new PhenotypesRetrievalRunner(vibeOptions.getHpoOntology(), vibeOptions.getPhenotypesRetrieverFactory(), vibeOptions.getPhenotypes(), vibeOptions.getOntologyMaxDistance()).call();
            RunMode.printElapsedTime(vibeOptions, stopwatch);
            return phenotypeNetworkCollection;
        }
    }
    ,
    GENES_FOR_PHENOTYPES("Retrieves genes for input phenotypes."){

        @Override
        protected void runMode(VibeOptions vibeOptions, Stopwatch stopwatch) throws Exception {
            GeneDiseaseCollection geneDiseaseCollection = RunMode.retrieveDisgenetData(vibeOptions, stopwatch, this.retrieveInputPhenotypes(vibeOptions));
            List genePriority = RunMode.orderGenes(vibeOptions, stopwatch, geneDiseaseCollection);
            RunMode.writePrioritizedGenesOutput(vibeOptions, stopwatch, geneDiseaseCollection, genePriority);
        }

        private Set<Phenotype> retrieveInputPhenotypes(VibeOptions vibeOptions) {
            return vibeOptions.getPhenotypes();
        }
    };

    private VibeOptions vibeOptions;
    private String description;
    private Stopwatch stopwatch;

    private static GeneDiseaseCollection retrieveDisgenetData(VibeOptions vibeOptions, Stopwatch stopwatch, Set<Phenotype> phenotypes) throws IOException {
        vibeOptions.printVerbose("# Retrieving data from main dataset.");
        RunMode.resetTimer(stopwatch);
        GeneDiseaseCollection geneDiseaseCollection = new GeneDiseaseCollectionRetrievalRunner(vibeOptions.getVibeTdb(), phenotypes).call();
        RunMode.printElapsedTime(vibeOptions, stopwatch);
        return geneDiseaseCollection;
    }

    private static List<Gene> orderGenes(VibeOptions vibeOptions, Stopwatch stopwatch, GeneDiseaseCollection geneDiseaseCollection) {
        vibeOptions.printVerbose("# Ordering genes based on priority.");
        RunMode.resetTimer(stopwatch);
        HighestSingleDisgenetScoreGenePrioritizer prioritizer = new HighestSingleDisgenetScoreGenePrioritizer();
        List<Gene> genePriority = prioritizer.sort(geneDiseaseCollection);
        RunMode.printElapsedTime(vibeOptions, stopwatch);
        return genePriority;
    }

    private static void writePrioritizedGenesOutput(VibeOptions vibeOptions, Stopwatch stopwatch, GeneDiseaseCollection geneDiseaseCollection, List<Gene> genePriority) throws IOException {
        vibeOptions.printVerbose("# Writing genes to " + vibeOptions.getOutputWriter().target());
        RunMode.resetTimer(stopwatch);
        vibeOptions.getGenePrioritizedOutputFormatWriterFactory().create(vibeOptions.getOutputWriter(), geneDiseaseCollection, genePriority).run();
        RunMode.printElapsedTime(vibeOptions, stopwatch);
    }

    protected String getDescription() {
        return this.description;
    }

    private RunMode(String description) {
        this.description = description;
    }

    public final void run(VibeOptions vibeOptions) throws Exception {
        this.vibeOptions = vibeOptions;
        this.vibeOptions.printVerbose(this.getDescription());
        this.stopwatch = Stopwatch.createStarted();
        this.runMode(vibeOptions, this.stopwatch);
    }

    protected abstract void runMode(VibeOptions var1, Stopwatch var2) throws Exception;

    private static void resetTimer(Stopwatch stopwatch) {
        stopwatch.reset();
        stopwatch.start();
    }

    private static void printElapsedTime(VibeOptions vibeOptions, Stopwatch stopwatch) {
        vibeOptions.printVerbose("Elapsed time: " + stopwatch.toString());
    }
}

