/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.cli;

import java.io.IOException;
import org.apache.commons.cli.ParseException;
import org.molgenis.vibe.cli.io.options_digestion.CommandLineOptionsParser;
import org.molgenis.vibe.cli.io.options_digestion.VibeOptions;
import org.molgenis.vibe.cli.properties.VibePropertiesLoader;

public class VibeApplication {
    public static void main(String[] args) {
        if (VibeApplication.loadPropertiesFile()) {
            try {
                VibeOptions vibeOptions = new VibeOptions();
                CommandLineOptionsParser.parse(args, vibeOptions);
                if (vibeOptions.validate()) {
                    VibeApplication.executeRunMode(vibeOptions);
                } else {
                    VibeApplication.printUnexpectedExceptionOccurred();
                    vibeOptions.toString();
                }
            }
            catch (ParseException e2) {
                System.err.println(e2.getLocalizedMessage());
            }
        }
    }

    private static boolean loadPropertiesFile() {
        try {
            VibePropertiesLoader.loadProperties();
        }
        catch (IOException e2) {
            System.err.println("Failed to load properties file. Please contact the developer.");
            return false;
        }
        return true;
    }

    private static void executeRunMode(VibeOptions vibeOptions) {
        try {
            vibeOptions.getRunMode().run(vibeOptions);
        }
        catch (IOException e2) {
            System.err.println(e2.getLocalizedMessage());
        }
        catch (Exception e3) {
            VibeApplication.printUnexpectedExceptionOccurred();
            e3.printStackTrace();
        }
    }

    public static void printUnexpectedExceptionOccurred() {
        System.err.println("######## ######## ########");
        System.err.println("An unexpected exception occurred. Please notify the developer (see https://github.com/molgenis/vibe) and supply the text as seen below.");
        System.err.println("######## ######## ########");
    }
}

