/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.cli.io.options_digestion;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.molgenis.vibe.cli.RunMode;
import org.molgenis.vibe.cli.io.output.format.gene_prioritized.GenePrioritizedOutputFormatWriterFactory;
import org.molgenis.vibe.cli.io.output.target.FileOutputWriter;
import org.molgenis.vibe.cli.io.output.target.OutputWriter;
import org.molgenis.vibe.cli.io.output.target.StdoutOutputWriter;
import org.molgenis.vibe.core.exceptions.InvalidStringFormatException;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.ontology_processing.PhenotypesRetrieverFactory;

public class VibeOptions {
    private RunMode runMode;
    private boolean verbose = false;
    private Path hpoOntology;
    private Path vibeTdb;
    private Set<Phenotype> phenotypes = new HashSet<Phenotype>();
    private PhenotypesRetrieverFactory phenotypesRetrieverFactory;
    private Integer ontologyMaxDistance;
    private GenePrioritizedOutputFormatWriterFactory genePrioritizedOutputFormatWriterFactory;
    private OutputWriter outputWriter;

    public RunMode getRunMode() {
        return this.runMode;
    }

    void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void printVerbose(String text) {
        if (this.verbose) {
            System.out.println(text);
        }
    }

    public Path getHpoOntology() {
        return this.hpoOntology;
    }

    void setHpoOntology(String hpoOntology) throws InvalidPathException, IOException {
        this.setHpoOntology(Paths.get(hpoOntology, new String[0]));
    }

    void setHpoOntology(Path hpoOntology) throws IOException {
        if (!this.checkIfPathIsReadableFile(hpoOntology)) {
            throw new IOException(hpoOntology.getFileName() + " is not a readable file.");
        }
        this.hpoOntology = hpoOntology;
    }

    public Path getVibeTdb() {
        return this.vibeTdb;
    }

    void setVibeTdb(String vibeTdb) throws IOException {
        this.setVibeTdb(Paths.get(vibeTdb, new String[0]));
    }

    void setVibeTdb(Path vibeTdb) throws IOException {
        if (!this.checkIfPathIsDir(vibeTdb)) {
            throw new IOException(vibeTdb.getFileName() + " is not a directory.");
        }
        this.vibeTdb = vibeTdb;
    }

    public Set<Phenotype> getPhenotypes() {
        return this.phenotypes;
    }

    void setPhenotypes(Set<Phenotype> phenotypes) {
        this.phenotypes = phenotypes;
    }

    void addPhenotypes(Set<Phenotype> phenotypes) {
        this.phenotypes.addAll(phenotypes);
    }

    void addPhenotype(Phenotype phenotype) {
        this.phenotypes.add(phenotype);
    }

    public PhenotypesRetrieverFactory getPhenotypesRetrieverFactory() {
        return this.phenotypesRetrieverFactory;
    }

    void setPhenotypesRetrieverFactory(String name) throws EnumConstantNotPresentException {
        this.setPhenotypesRetrieverFactory(PhenotypesRetrieverFactory.retrieve(name));
    }

    void setPhenotypesRetrieverFactory(PhenotypesRetrieverFactory phenotypesRetrieverFactory) {
        this.phenotypesRetrieverFactory = phenotypesRetrieverFactory;
    }

    public Integer getOntologyMaxDistance() {
        return this.ontologyMaxDistance;
    }

    void setOntologyMaxDistance(String ontologyMaxDistance) throws NumberFormatException {
        this.setOntologyMaxDistance(Integer.parseInt(ontologyMaxDistance));
    }

    void setOntologyMaxDistance(Integer ontologyMaxDistance) {
        if (ontologyMaxDistance < 0) {
            throw new IllegalArgumentException("value must be >= 0.");
        }
        this.ontologyMaxDistance = ontologyMaxDistance;
    }

    public GenePrioritizedOutputFormatWriterFactory getGenePrioritizedOutputFormatWriterFactory() {
        return this.genePrioritizedOutputFormatWriterFactory;
    }

    void setGenePrioritizedOutputFormatWriterFactory(GenePrioritizedOutputFormatWriterFactory genePrioritizedOutputFormatWriterFactory) {
        this.genePrioritizedOutputFormatWriterFactory = genePrioritizedOutputFormatWriterFactory;
    }

    void setPhenotypes(String[] phenotypes) throws InvalidStringFormatException {
        this.phenotypes = new HashSet<Phenotype>();
        this.addPhenotypes(phenotypes);
    }

    void addPhenotypes(String[] phenotypes) throws InvalidStringFormatException {
        for (int i = 0; i < phenotypes.length; ++i) {
            this.addPhenotype(phenotypes[i]);
        }
    }

    void addPhenotype(String phenotype) throws InvalidStringFormatException {
        this.addPhenotype(new Phenotype(phenotype));
    }

    public OutputWriter getOutputWriter() {
        return this.outputWriter;
    }

    protected void setFileOutputWriter(String outputFile) throws InvalidPathException, FileAlreadyExistsException {
        this.setFileOutputWriter(Paths.get(outputFile, new String[0]));
    }

    protected void setFileOutputWriter(Path outputFile) throws FileAlreadyExistsException {
        if (this.checkIfPathIsWritableFile(outputFile)) {
            throw new FileAlreadyExistsException(outputFile.getFileName() + " already exists.");
        }
        this.outputWriter = new FileOutputWriter(outputFile);
    }

    protected void setFileOutputWriterForced(String outputFile) throws InvalidPathException {
        this.setFileOutputWriterForced(Paths.get(outputFile, new String[0]));
    }

    protected void setFileOutputWriterForced(Path outputFile) {
        this.checkIfPathIsWritableFile(outputFile);
        this.outputWriter = new FileOutputWriter(outputFile);
    }

    protected void setStdoutOutputWriter() {
        this.outputWriter = new StdoutOutputWriter();
    }

    private boolean checkIfPathIsReadableFile(Path path) {
        return Files.isReadable(path) && Files.isRegularFile(path, new LinkOption[0]);
    }

    private boolean checkIfPathIsWritableFile(Path path) {
        return Files.isWritable(path) && Files.isRegularFile(path, new LinkOption[0]);
    }

    private boolean checkIfPathIsDir(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public boolean validate() {
        switch (this.runMode) {
            case GENES_FOR_PHENOTYPES_WITH_ASSOCIATED_PHENOTYPES: {
                if (!this.validateRelatedPhenotypesRetrieval()) {
                    return false;
                }
            }
            case GENES_FOR_PHENOTYPES: {
                if (this.validateGenesForPhenotype()) break;
                return false;
            }
        }
        return true;
    }

    private boolean validateRelatedPhenotypesRetrieval() {
        if (this.getPhenotypesRetrieverFactory() == null) {
            return false;
        }
        return this.getOntologyMaxDistance() != null;
    }

    private boolean validateGenesForPhenotype() {
        if (this.getVibeTdb() == null) {
            return false;
        }
        if (this.getHpoOntology() == null) {
            return false;
        }
        if (this.getOutputWriter() == null) {
            return false;
        }
        if (this.getGenePrioritizedOutputFormatWriterFactory() == null) {
            return false;
        }
        return !this.getPhenotypes().isEmpty();
    }

    public String toString() {
        return "VibeOptions{runMode=" + (Object)((Object)this.runMode) + ", verbose=" + this.verbose + ", hpoOntology=" + this.hpoOntology + ", vibeTdb=" + this.vibeTdb + ", phenotypes=" + this.phenotypes + ", phenotypesRetrieverFactory=" + this.phenotypesRetrieverFactory + ", ontologyMaxDistance=" + this.ontologyMaxDistance + ", genePrioritizedOutputFormatWriterFactory=" + this.genePrioritizedOutputFormatWriterFactory + ", outputWriter=" + this.outputWriter + '}';
    }
}

