/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.io.input.TripleStoreDbReader;
import org.molgenis.vibe.core.tdb_processing.GenesForPhenotypeRetriever;

public class GeneDiseaseCollectionRetrievalRunner
implements Callable<GeneDiseaseCollection> {
    private Path vibeTdb;
    private Set<Phenotype> phenotypes;

    public GeneDiseaseCollectionRetrievalRunner(Path vibeTdb, Set<Phenotype> phenotypes) {
        this.vibeTdb = Objects.requireNonNull(vibeTdb);
        this.phenotypes = phenotypes;
    }

    @Override
    public GeneDiseaseCollection call() throws IOException {
        try (TripleStoreDbReader disgenetReader = new TripleStoreDbReader(this.vibeTdb);){
            GenesForPhenotypeRetriever genesForPhenotypeRetriever = new GenesForPhenotypeRetriever(disgenetReader, this.phenotypes);
            genesForPhenotypeRetriever.run();
            GeneDiseaseCollection geneDiseaseCollection = genesForPhenotypeRetriever.getGeneDiseaseCollection();
            return geneDiseaseCollection;
        }
    }
}

