/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.net.URI;
import java.util.Objects;
import org.molgenis.vibe.core.formats.BiologicalEntity;
import org.molgenis.vibe.core.formats.Entity;
import org.molgenis.vibe.core.formats.EntityWithIntId;
import org.molgenis.vibe.core.formats.GeneSymbol;

public class Gene
extends BiologicalEntity
implements EntityWithIntId {
    public static final String ID_PREFIX = "ncbigene";
    private static final String ID_REGEX = "^(ncbigene|NCBIGENE):([0-9]+)$";
    private static final int REGEX_ID_GROUP = 2;
    private static final String URI_PREFIX = "http://identifiers.org/ncbigene/";
    private GeneSymbol symbol;
    private int idInt = Integer.parseInt(this.getId());

    public GeneSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public int getIdInt() {
        return this.idInt;
    }

    @Override
    protected String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    protected String getIdRegex() {
        return ID_REGEX;
    }

    @Override
    protected int getRegexIdGroup() {
        return 2;
    }

    @Override
    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public Gene(String id, GeneSymbol symbol) {
        super(id);
        this.symbol = Objects.requireNonNull(symbol);
    }

    public Gene(URI uri, GeneSymbol symbol) {
        super(uri);
        this.symbol = Objects.requireNonNull(symbol);
    }

    @Override
    public String toString() {
        return "Gene{symbol='" + this.symbol + '\'' + ' ' + super.toString() + '}';
    }

    @Override
    public int compareTo(Entity o) {
        if (o instanceof Gene) {
            Gene oGene = (Gene)o;
            return this.idInt - oGene.idInt;
        }
        return super.compareTo(o);
    }

    @Override
    public boolean allFieldsEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Gene gene = (Gene)o;
        return super.allFieldsEquals(gene) && this.idInt == gene.idInt && this.symbol.allFieldsEquals(gene.symbol);
    }
}

