/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.molgenis.vibe.core.formats.BiologicalEntityCollection;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;

public class GeneDiseaseCollection
extends BiologicalEntityCollection<Gene, Disease, GeneDiseaseCombination> {
    public Set<Gene> getGenes() {
        return this.getT1();
    }

    public Set<Disease> getDiseases() {
        return this.getT2();
    }

    public Set<GeneDiseaseCombination> getGeneDiseaseCombinations() {
        return this.getT3();
    }

    public List<GeneDiseaseCombination> getGeneDiseaseCombinationsOrdered() {
        return this.getT3Ordered();
    }

    public Set<GeneDiseaseCombination> getByGene(Gene gene) {
        return this.getByT1(gene);
    }

    public Set<GeneDiseaseCombination> getByDisease(Disease disease) {
        return this.getByT2(disease);
    }

    public GeneDiseaseCollection() {
    }

    public GeneDiseaseCollection(Set<GeneDiseaseCombination> combinationsMap) {
        super(combinationsMap);
    }

    public List<GeneDiseaseCombination> getByGeneOrderedByGdaScore(Gene gene) {
        return this.getByBiologicalEntityOrderedByGdaScore(this.getByGene(gene));
    }

    public List<GeneDiseaseCombination> getByDiseaseOrderedByGdaScore(Disease disease) {
        return this.getByBiologicalEntityOrderedByGdaScore(this.getByDisease(disease));
    }

    private List<GeneDiseaseCombination> getByBiologicalEntityOrderedByGdaScore(Set<GeneDiseaseCombination> geneDiseaseCombinationSet) {
        ArrayList<GeneDiseaseCombination> orderedList = new ArrayList<GeneDiseaseCombination>();
        orderedList.addAll(geneDiseaseCombinationSet);
        orderedList.sort(Comparator.comparing(GeneDiseaseCombination::getDisgenetScore).reversed());
        return orderedList;
    }
}

