/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.GeneDiseaseCollectionJsonSerialization;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.formats.GeneSymbol;
import org.molgenis.vibe.core.formats.PubmedEvidence;
import org.molgenis.vibe.core.formats.Source;

public class GeneDiseaseCollectionDeserializer
extends GeneDiseaseCollectionJsonSerialization
implements JsonDeserializer<GeneDiseaseCollection> {
    @Override
    public GeneDiseaseCollection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context2) throws JsonParseException {
        JsonObject collectionObject = json.getAsJsonObject();
        return this.generateGeneDiseaseCollection(collectionObject.getAsJsonArray("combinations"), this.retrieveGenes(collectionObject.getAsJsonObject("ncbigene")), this.retrieveDiseases(collectionObject.getAsJsonObject("umls")), this.retrieveSources(collectionObject.getAsJsonObject("sources")));
    }

    private GeneDiseaseCollection generateGeneDiseaseCollection(JsonArray combinationsArray, Map<String, Gene> genesMap, Map<String, Disease> diseasesMap, Map<String, Source> sourcesMap) {
        GeneDiseaseCollection collection = new GeneDiseaseCollection();
        System.out.println(sourcesMap);
        Iterator<JsonElement> combinationsIterator = combinationsArray.iterator();
        while (combinationsIterator.hasNext()) {
            JsonObject combinationObject = combinationsIterator.next().getAsJsonObject();
            Gene gene = genesMap.get(combinationObject.getAsJsonPrimitive("ncbigene").getAsString());
            Disease disease = diseasesMap.get(combinationObject.getAsJsonPrimitive("umls").getAsString());
            Double disgenetScore = combinationObject.getAsJsonPrimitive("score").getAsDouble();
            GeneDiseaseCombination geneDiseaseCombination = new GeneDiseaseCombination(gene, disease, disgenetScore);
            Iterator<JsonElement> combinationSourcesIterator = combinationObject.getAsJsonArray("sources").iterator();
            while (combinationSourcesIterator.hasNext()) {
                JsonObject sourceObject = combinationSourcesIterator.next().getAsJsonObject();
                Source source = sourcesMap.get(sourceObject.getAsJsonPrimitive("name").getAsString());
                int sourceCount = sourceObject.getAsJsonPrimitive("count").getAsInt();
                geneDiseaseCombination.setSourceCount(source, sourceCount);
                HashSet<PubmedEvidence> pubmedEvidenceForSource = new HashSet<PubmedEvidence>();
                JsonArray pubmedsArray = sourceObject.getAsJsonArray("pubmed");
                Iterator<JsonElement> pubmedsIterator = pubmedsArray.iterator();
                while (pubmedsIterator.hasNext()) {
                    JsonObject pubmedObject = pubmedsIterator.next().getAsJsonObject();
                    URI pubmedUri = URI.create(pubmedObject.getAsJsonPrimitive("uri").getAsString());
                    int pubmedYear = pubmedObject.getAsJsonPrimitive("year").getAsInt();
                    pubmedEvidenceForSource.add(new PubmedEvidence(pubmedUri, pubmedYear));
                }
                if (pubmedEvidenceForSource.isEmpty()) continue;
                geneDiseaseCombination.setPubmedEvidenceForSource(source, pubmedEvidenceForSource);
            }
            collection.add(geneDiseaseCombination);
        }
        return collection;
    }

    private Map<String, Gene> retrieveGenes(JsonObject jsonObject) {
        HashMap<String, Gene> genesMap = new HashMap<String, Gene>();
        for (String geneId : jsonObject.keySet()) {
            JsonObject geneObject = jsonObject.getAsJsonObject(geneId);
            String fullGeneId = "ncbigene:" + geneId;
            String fullGeneSymbolId = "hgnc:" + geneObject.getAsJsonPrimitive("hgnc").getAsString();
            genesMap.put(geneId, new Gene(fullGeneId, new GeneSymbol(fullGeneSymbolId)));
        }
        return genesMap;
    }

    private Map<String, Disease> retrieveDiseases(JsonObject jsonObject) {
        HashMap<String, Disease> diseasesMap = new HashMap<String, Disease>();
        for (String diseaseId : jsonObject.keySet()) {
            JsonObject diseaseObject = jsonObject.getAsJsonObject(diseaseId);
            String fullDiseaseId = "umls:" + diseaseId;
            String diseaseName = diseaseObject.getAsJsonPrimitive("name").getAsString();
            diseasesMap.put(diseaseId, new Disease(fullDiseaseId, diseaseName));
        }
        return diseasesMap;
    }

    private Map<String, Source> retrieveSources(JsonObject jsonObject) {
        HashMap<String, Source> sourcesMap = new HashMap<String, Source>();
        for (String sourceName : jsonObject.keySet()) {
            JsonObject sourceObject = jsonObject.getAsJsonObject(sourceName);
            URI sourceUri = URI.create(sourceObject.getAsJsonPrimitive("uri").getAsString());
            String sourceFullName = sourceObject.getAsJsonPrimitive("fullName").getAsString();
            String levelString = sourceObject.getAsJsonPrimitive("level").getAsString();
            sourcesMap.put(sourceName, new Source(sourceUri, sourceFullName, levelString));
        }
        return sourcesMap;
    }
}

