/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.tdb_processing;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.molgenis.vibe.core.tdb_processing.query_string_creation.QueryString;

public class QueryRunner
implements Closeable,
Iterator<QuerySolution> {
    private QueryExecution qexec;
    private ResultSet results;

    public QueryRunner(Model model, QueryString queryString) {
        Query query = QueryFactory.create(queryString.getQuery(), queryString.getSyntax());
        this.qexec = QueryExecutionFactory.create(query, model);
        this.results = this.qexec.execSelect();
    }

    public ResultSet getResultSet() {
        return this.results;
    }

    @Override
    public boolean hasNext() {
        return this.results.hasNext();
    }

    @Override
    public QuerySolution next() {
        return this.results.next();
    }

    @Override
    public void close() {
        this.qexec.close();
    }
}

