/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.sys;

import java.util.UUID;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.shared.uuid.JenaUUID;

public class LibUUID {
    public static byte[] uuidAsBytes(UUID uuid2) {
        return LibUUID.uuidAsBytes(uuid2.getMostSignificantBits(), uuid2.getLeastSignificantBits());
    }

    public static byte[] uuidAsBytes(JenaUUID uuid2) {
        return LibUUID.uuidAsBytes(uuid2.getMostSignificantBits(), uuid2.getLeastSignificantBits());
    }

    public static byte[] uuidAsBytes(long mostSignificantBits, long leastSignificantBits) {
        byte[] bytes = new byte[16];
        Bytes.setLong(mostSignificantBits, bytes, 0);
        Bytes.setLong(leastSignificantBits, bytes, 8);
        return bytes;
    }

    public static byte[] uuidAsBytes(String str2) {
        return LibUUID.uuidAsBytes(UUID.fromString(str2));
    }

    public static String uuidToString(long mostSignificantBits, long leastSignificantBits) {
        return new UUID(mostSignificantBits, leastSignificantBits).toString();
    }
}

