/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shacl.lib.GN;
import org.apache.jena.shacl.lib.RDFDataException;
import org.apache.jena.shacl.lib.Transitive;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.util.iterator.ExtendedIterator;

public class G {
    public static Node subject(Triple triple) {
        return triple == null ? null : triple.getSubject();
    }

    public static Node predicate(Triple triple) {
        return triple == null ? null : triple.getPredicate();
    }

    public static Node object(Triple triple) {
        return triple == null ? null : triple.getObject();
    }

    public static boolean isURI(Node n) {
        return n != null && n.isURI();
    }

    public static boolean isBlank(Node n) {
        return n != null && n.isBlank();
    }

    public static boolean isLiteral(Node n) {
        return n != null && n.isLiteral();
    }

    public static boolean isResource(Node n) {
        return n != null && (n.isURI() || n.isBlank());
    }

    public static boolean isOfType(Graph graph, Node x, Node type) {
        Objects.requireNonNull(x, "Subject");
        Objects.requireNonNull(type, "Type");
        List<Node> allClasses = G.listSubClasses(graph, type);
        for (Node c : allClasses) {
            if (!G.hasType(graph, x, c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(Graph graph, Node x, Node type) {
        Objects.requireNonNull(x, "Subject");
        Objects.requireNonNull(type, "Type");
        return G.contains(graph, x, C.rdfType, type);
    }

    public static Node getSP(Graph graph, Node s, Node p) {
        return G.object(G.first(G.find(graph, s, p, Node.ANY)));
    }

    public static List<Node> listSP(Graph graph, Node s, Node p) {
        return G.iterSP(graph, s, p).toList();
    }

    public static long countSP(Graph graph, Node s, Node p) {
        return Iter.count(G.iterSP(graph, s, p));
    }

    public static ExtendedIterator<Node> iterSP(Graph graph, Node s, Node p) {
        return graph.find(s, p, null).mapWith(Triple::getObject);
    }

    public static List<Node> listPO(Graph graph, Node p, Node o) {
        return graph.find(null, p, o).mapWith(Triple::getSubject).toList();
    }

    public static List<Node> listSubjectsOfType(Graph graph, Node type) {
        return graph.find(null, C.rdfType, type).mapWith(Triple::getSubject).toList();
    }

    public static List<Node> rdfList(Graph graph, Node node) {
        GNode gNode = GN.create(graph, node);
        return GraphList.members(gNode);
    }

    public static List<Node> listSubClasses(Graph graph, Node type) {
        ArrayList<Node> acc = new ArrayList<Node>();
        Transitive.transitiveInc(graph, false, type, C.rdfsSubclassOf, acc);
        return acc;
    }

    public static List<Node> listSuperClasses(Graph graph, Node type) {
        ArrayList<Node> acc = new ArrayList<Node>();
        Transitive.transitiveInc(graph, true, type, C.rdfsSubclassOf, acc);
        return acc;
    }

    public static List<Node> listNodesOfType(Graph graph, Node type) {
        return graph.find(null, C.rdfType, type).mapWith(Triple::getSubject).toList();
    }

    public static List<Node> listTypesOfNode(Graph graph, Node subject) {
        return graph.find(subject, C.rdfType, null).mapWith(Triple::getObject).toList();
    }

    public static List<Node> listAllTypesOfNode(Graph graph, Node subject) {
        List<Node> types = G.listTypesOfNode(graph, subject);
        ArrayList<Node> types2 = new ArrayList<Node>();
        types.forEach(t -> {
            List<Node> subClasses = G.listSuperClasses(graph, t);
            types2.addAll(subClasses);
        });
        return types2;
    }

    public static List<Node> listAllNodesOfType(Graph graph, Node type) {
        List<Node> types = G.listSubClasses(graph, type);
        ArrayList<Node> nodes = new ArrayList<Node>();
        types.forEach(t -> nodes.addAll(G.listNodesOfType(graph, t)));
        return nodes;
    }

    public static Set<Node> setNodesOfType(Graph graph, Node type) {
        return graph.find(null, C.rdfType, type).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> setTypesOfNode(Graph graph, Node subject) {
        return graph.find(subject, C.rdfType, null).mapWith(Triple::getObject).toSet();
    }

    public static Set<Node> setSubClasses(Graph graph, Node type) {
        HashSet<Node> acc = new HashSet<Node>();
        Transitive.transitiveInc(graph, false, type, C.rdfsSubclassOf, acc);
        return acc;
    }

    public static Set<Node> setAllNodesOfType(Graph graph, Node type) {
        Set<Node> types = G.setSubClasses(graph, type);
        HashSet<Node> nodes = new HashSet<Node>();
        types.forEach(t -> nodes.addAll(G.listNodesOfType(graph, t)));
        return nodes;
    }

    public static Set<Node> setSP(Graph graph, Node s, Node p) {
        return graph.find(s, p, null).mapWith(Triple::getObject).toSet();
    }

    public static Set<Node> setPO(Graph graph, Node p, Node o) {
        return graph.find(null, p, o).mapWith(Triple::getSubject).toSet();
    }

    public static Node getOneSP(Graph graph, Node s, Node p) {
        return G.object(G.findUnique(graph, s, p, Node.ANY));
    }

    public static Node getZeroOrOneSP(Graph graph, Node s, Node p) {
        return G.object(G.findZeroOne(graph, s, p, Node.ANY));
    }

    public static Triple getOne(Graph graph, Node s, Node p, Node o) {
        return G.findUnique(graph, s, p, Node.ANY);
    }

    public static boolean contains(Graph g, Node s, Node p, Node o) {
        return g.contains(s, p, o);
    }

    public static boolean absentOrOne(Graph g, Node s, Node p, Node o) {
        if (!g.contains(s, p, o)) {
            return false;
        }
        long x = Iter.count(g.find(s, p, null));
        if (x == 1L) {
            return true;
        }
        throw new RDFDataException("More then one (" + x + ") " + G.matchStr(s, p, o));
    }

    public static boolean containsOne(Graph g, Node s, Node p, Node o) {
        return g.contains(s, p, o) && Iter.count(g.find(s, p, null)) == 1L;
    }

    public static boolean hasProperty(Graph g, Node s, Node p) {
        return g.contains(s, p, null);
    }

    public static ExtendedIterator<Triple> find(Graph g, Node s, Node p, Node o) {
        return g.find(s, p, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple findUnique(Graph g, Node s, Node p, Node o) {
        try (ExtendedIterator<Triple> iter = g.find(s, p, o);){
            if (!iter.hasNext()) {
                throw new RDFDataException("No match : " + G.matchStr(s, p, o));
            }
            Triple x = (Triple)iter.next();
            if (iter.hasNext()) {
                throw new RDFDataException("More than one match : " + G.matchStr(s, p, o));
            }
            Triple triple = x;
            return triple;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple findZeroOne(Graph g, Node s, Node p, Node o) {
        try (ExtendedIterator<Triple> iter = g.find(s, p, o);){
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple x = (Triple)iter.next();
            if (iter.hasNext()) {
                throw new RDFDataException("More than one match : " + G.matchStr(s, p, o));
            }
            Triple triple = x;
            return triple;
        }
    }

    private static String matchStr(Node s, Node p, Node o) {
        return "(" + NodeFmtLib.strNodes(s, p, o) + ")";
    }

    private static Triple first(ExtendedIterator<Triple> iter) {
        try {
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple triple = (Triple)iter.next();
            return triple;
        }
        finally {
            iter.close();
        }
    }

    @SafeVarargs
    public static <X> boolean allNonNull(X ... objects) {
        return G.countNonNulls(objects) == objects.length;
    }

    @SafeVarargs
    public static <X> boolean exactlyOneSet(X ... objects) {
        return G.countNonNulls(objects) == 1;
    }

    @SafeVarargs
    public static <X> X atMostOne(X ... objects) {
        int c = 0;
        X x = null;
        for (X obj : objects) {
            if (obj == null) continue;
            if (++c > 1) {
                throw new RDFDataException("ExactlyOne:" + Arrays.asList(objects));
            }
            if (x != null) continue;
            x = obj;
        }
        return x;
    }

    @SafeVarargs
    public static <X> int countNonNulls(X ... objects) {
        int x = 0;
        for (X obj : objects) {
            if (obj == null) continue;
            ++x;
        }
        return x;
    }
}

