/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.system.DatasetGraphStorage;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.params.StoreParams;
import org.apache.jena.tdb2.store.GraphTDB;
import org.apache.jena.tdb2.store.QuadTable;
import org.apache.jena.tdb2.store.StorageTDB;
import org.apache.jena.tdb2.store.TripleTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public final class DatasetGraphTDB
extends DatasetGraphStorage {
    private final StorageTDB storageTDB;
    private final Location location;
    private final TransactionalSystem txnSystem;
    private final StoreParams storeParams;
    private final ReorderTransformation reorderTransformation;
    private boolean isClosed = false;

    public DatasetGraphTDB(Location location, StoreParams params, ReorderTransformation reorderTransformation, StorageTDB storage, StoragePrefixes prefixes, TransactionalSystem txnSystem) {
        super(storage, prefixes, txnSystem);
        this.storageTDB = storage;
        this.location = location;
        this.storeParams = params;
        this.txnSystem = txnSystem;
        this.reorderTransformation = reorderTransformation;
    }

    private void checkNotClosed() {
        if (this.isClosed) {
            throw new TDBException("dataset closed");
        }
    }

    @Override
    public boolean supportsTransactionAbort() {
        return true;
    }

    public Location getLocation() {
        return this.location;
    }

    public QuadTable getQuadTable() {
        this.checkNotClosed();
        return this.storageTDB.getQuadTable();
    }

    public TripleTable getTripleTable() {
        this.checkNotClosed();
        return this.storageTDB.getTripleTable();
    }

    public TransactionalSystem getTxnSystem() {
        return this.txnSystem;
    }

    public StoreParams getStoreParams() {
        return this.storeParams;
    }

    public ReorderTransformation getReorderTransform() {
        return this.reorderTransformation;
    }

    @Override
    public void close() {
        this.isClosed = true;
        super.close();
    }

    public void shutdown() {
        this.close();
        this.txnSystem.getTxnMgr().shutdown();
    }

    @Override
    public Graph getDefaultGraph() {
        return this.getDefaultGraphTDB();
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return this.getGraphTDB(graphNode);
    }

    @Override
    public Graph getUnionGraph() {
        return this.getUnionGraphTDB();
    }

    public GraphTDB getDefaultGraphTDB() {
        this.checkNotClosed();
        return GraphTDB.tdb_createDefaultGraph(this, this.getPrefixes());
    }

    public GraphTDB getGraphTDB(Node graphNode) {
        this.checkNotClosed();
        return GraphTDB.tdb_createNamedGraph(this, graphNode, this.getPrefixes());
    }

    public GraphTDB getUnionGraphTDB() {
        this.checkNotClosed();
        return GraphTDB.tdb_createUnionGraph(this, this.getPrefixes());
    }

    public NodeTupleTable chooseNodeTupleTable(Node graphNode) {
        this.checkNotClosed();
        if (graphNode == null || Quad.isDefaultGraph(graphNode)) {
            return this.getTripleTable().getNodeTupleTable();
        }
        return this.getQuadTable().getNodeTupleTable();
    }
}

