/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.molgenis.vibe.core.formats.BiologicalEntityCombination;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.PubmedEvidence;
import org.molgenis.vibe.core.formats.Source;

public class GeneDiseaseCombination
extends BiologicalEntityCombination<Gene, Disease> {
    private Double disgenetScore;
    private Map<Source, Integer> sourcesCount = new HashMap<Source, Integer>();
    private Map<Source, Set<PubmedEvidence>> pubmedEvidence = new HashMap<Source, Set<PubmedEvidence>>();

    public Gene getGene() {
        return (Gene)this.getT1();
    }

    public Disease getDisease() {
        return (Disease)this.getT2();
    }

    public double getDisgenetScore() {
        return this.disgenetScore;
    }

    public Map<Source, Integer> getSourcesCount() {
        return Collections.unmodifiableMap(this.sourcesCount);
    }

    public int getCountForSource(Source source) {
        Integer count = this.sourcesCount.get(source);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    public Set<Source> getSourcesWithPubmedEvidence() {
        return Collections.unmodifiableSet(this.pubmedEvidence.keySet());
    }

    public Set<PubmedEvidence> getPubmedEvidenceForSource(Source source) {
        Set<PubmedEvidence> evidence = this.pubmedEvidence.get(source);
        if (evidence != null) {
            evidence = Collections.unmodifiableSet(evidence);
        }
        return evidence;
    }

    public List<PubmedEvidence> getPubmedEvidenceForSourceSortedByReleaseDate(Source source) {
        ArrayList<PubmedEvidence> evidenceList = null;
        Set<PubmedEvidence> evidence = this.pubmedEvidence.get(source);
        if (evidence != null) {
            evidenceList = new ArrayList<PubmedEvidence>();
            evidenceList.addAll(evidence);
            Collections.sort(evidenceList, PubmedEvidence.RELEASE_YEAR_COMPARATOR);
        }
        return evidenceList;
    }

    public Set<PubmedEvidence> getAllPubmedEvidence() {
        HashSet<PubmedEvidence> evidence = new HashSet<PubmedEvidence>();
        this.pubmedEvidence.values().forEach(evidence::addAll);
        return evidence;
    }

    public List<PubmedEvidence> getAllPubMedEvidenceSortedByYear() {
        ArrayList<PubmedEvidence> evidence = new ArrayList<PubmedEvidence>();
        this.pubmedEvidence.values().forEach(evidence::addAll);
        Collections.sort(evidence, PubmedEvidence.RELEASE_YEAR_COMPARATOR);
        return evidence;
    }

    public GeneDiseaseCombination(Gene gene, Disease disease) {
        super(gene, disease);
    }

    public GeneDiseaseCombination(Gene gene, Disease disease, double disgenetScore) {
        super(gene, disease);
        this.disgenetScore = Objects.requireNonNull(disgenetScore);
    }

    public void add(Source source, PubmedEvidence evidence) {
        this.add(source);
        Set evidenceList = this.pubmedEvidence.computeIfAbsent(source, k -> new HashSet());
        evidenceList.add(evidence);
    }

    public void add(Source source) {
        Integer count = this.sourcesCount.get(source);
        if (count == null) {
            this.sourcesCount.put(source, 1);
        } else {
            this.sourcesCount.put(source, count + 1);
        }
    }

    void setSourceCount(Source source, int count) {
        this.sourcesCount.put(source, count);
    }

    void setPubmedEvidenceForSource(Source source, Set<PubmedEvidence> evidence) {
        this.pubmedEvidence.put(source, evidence);
    }

    @Override
    public String toString() {
        return "GeneDiseaseCombination{disgenetScore=" + this.disgenetScore + ", sourcesCount=" + this.sourcesCount + ", pubmedEvidence=" + this.pubmedEvidence + ' ' + super.toString() + '}';
    }

    @Override
    public boolean allFieldsEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeneDiseaseCombination that = (GeneDiseaseCombination)o;
        if (!(super.allFieldsEquals(that) && Objects.equals(this.disgenetScore, that.disgenetScore) && Objects.equals(this.sourcesCount, that.sourcesCount) && Objects.equals(this.pubmedEvidence, that.pubmedEvidence))) {
            return false;
        }
        for (Map.Entry<Source, Set<PubmedEvidence>> sourcePubmedEvidence : this.pubmedEvidence.entrySet()) {
            ArrayList thisPubmedEvidences = new ArrayList(sourcePubmedEvidence.getValue());
            Collections.sort(thisPubmedEvidences);
            ArrayList thatPubmedEvidences = new ArrayList(that.pubmedEvidence.get(sourcePubmedEvidence.getKey()));
            Collections.sort(thatPubmedEvidences);
            for (int i = 0; i < thisPubmedEvidences.size(); ++i) {
                if (((PubmedEvidence)thisPubmedEvidences.get(i)).allFieldsEquals(thatPubmedEvidences.get(i))) continue;
                return false;
            }
        }
        return true;
    }
}

