/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySectionMap;
import org.rdfhdt.hdt.dictionary.impl.section.PFCOptimizedExtractor;
import org.rdfhdt.hdt.enums.TripleComponentRole;

public class DictionaryPFCOptimizedExtractor {
    private final PFCOptimizedExtractor shared;
    private final PFCOptimizedExtractor subjects;
    private final PFCOptimizedExtractor predicates;
    private final PFCOptimizedExtractor objects;
    private final long numshared;

    public DictionaryPFCOptimizedExtractor(FourSectionDictionary origDict) {
        this.numshared = (int)origDict.getNshared();
        this.shared = new PFCOptimizedExtractor((PFCDictionarySectionMap)origDict.shared);
        this.subjects = new PFCOptimizedExtractor((PFCDictionarySectionMap)origDict.subjects);
        this.predicates = new PFCOptimizedExtractor((PFCDictionarySectionMap)origDict.predicates);
        this.objects = new PFCOptimizedExtractor((PFCDictionarySectionMap)origDict.objects);
    }

    public CharSequence idToString(long id, TripleComponentRole role) {
        PFCOptimizedExtractor section = this.getSection(id, role);
        long localId = this.getLocalId(id, role);
        return section.extract(localId);
    }

    private PFCOptimizedExtractor getSection(long id, TripleComponentRole role) {
        switch (role) {
            case SUBJECT: {
                if (id <= this.numshared) {
                    return this.shared;
                }
                return this.subjects;
            }
            case PREDICATE: {
                return this.predicates;
            }
            case OBJECT: {
                if (id <= this.numshared) {
                    return this.shared;
                }
                return this.objects;
            }
        }
        throw new IllegalArgumentException();
    }

    private long getLocalId(long id, TripleComponentRole position) {
        switch (position) {
            case SUBJECT: 
            case OBJECT: {
                if (id <= this.numshared) {
                    return id;
                }
                return id - this.numshared;
            }
            case PREDICATE: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }
}

