/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class JenaNodeCreator {
    private JenaNodeCreator() {
    }

    public static Node create(CharSequence x) {
        String str2 = x.toString();
        if (str2.length() == 0) {
            return JenaNodeCreator.createURI("");
        }
        char firstChar = str2.charAt(0);
        if (firstChar == '_') {
            return JenaNodeCreator.createAnon(str2);
        }
        if (firstChar == '\"') {
            return JenaNodeCreator.createLiteral(str2);
        }
        return JenaNodeCreator.createURI(str2);
    }

    public static Node createAnon(String str2) {
        return NodeFactory.createBlankNode(str2.substring(2));
    }

    public static Node createLiteral(String str2) {
        int len = str2.length();
        int next = 0;
        for (int i = len - 1; i > 0; --i) {
            char cur = str2.charAt(i);
            if (cur == '\"') {
                if (next == 64) {
                    String literal = str2.substring(1, i);
                    String lang = str2.substring(i + 2, len);
                    return NodeFactory.createLiteral(literal, lang);
                }
                String literal = str2.substring(1, i);
                return NodeFactory.createLiteral(literal);
            }
            if (cur == '^' && next == 94 && str2.charAt(i - 1) == '\"') {
                String literal = str2.substring(1, i - 1);
                String datatype = str2.charAt(i + 2) == '<' && str2.charAt(len - 1) == '>' ? str2.substring(i + 3, len - 1) : str2.substring(i + 2, len);
                RDFDatatype rdfDataType = TypeMapper.getInstance().getSafeTypeByName(datatype);
                return NodeFactory.createLiteral(literal, rdfDataType);
            }
            next = cur;
        }
        return NodeFactory.createLiteral(str2.substring(1, len - 2));
    }

    public static Node createURI(String str2) {
        return NodeFactory.createURI(str2);
    }
}

