/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.parsers.JenaNodeFormatter;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserRIOT
implements RDFParserCallback,
StreamRDF {
    private static final Logger log = LoggerFactory.getLogger(RDFParserRIOT.class);
    private RDFParserCallback.RDFCallback callback;
    private TripleString triple = new TripleString();

    @Override
    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        this.callback = callback;
        try {
            InputStream input = IOUtil.getFileInputStream(fileName);
            switch (notation) {
                case NTRIPLES: {
                    RDFDataMgr.parse((StreamRDF)this, input, Lang.NTRIPLES);
                    break;
                }
                case NQUAD: {
                    RDFDataMgr.parse((StreamRDF)this, input, Lang.NQUADS);
                    break;
                }
                case RDFXML: {
                    RDFDataMgr.parse((StreamRDF)this, input, baseUri, Lang.RDFXML);
                    break;
                }
                case N3: 
                case TURTLE: {
                    RDFDataMgr.parse((StreamRDF)this, input, baseUri, Lang.TURTLE);
                    break;
                }
                default: {
                    throw new NotImplementedException("Parser not found for format " + (Object)((Object)notation));
                }
            }
        }
        catch (FileNotFoundException e2) {
            throw new ParserException(e2);
        }
        catch (Exception e3) {
            log.error("Unexpected exception parsing file: {}", (Object)fileName, (Object)e3);
            throw new ParserException(e3);
        }
    }

    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        this.callback = callback;
        try {
            switch (notation) {
                case NTRIPLES: {
                    RDFDataMgr.parse((StreamRDF)this, input, Lang.NTRIPLES);
                    break;
                }
                case NQUAD: {
                    RDFDataMgr.parse((StreamRDF)this, input, Lang.NQUADS);
                    break;
                }
                case RDFXML: {
                    RDFDataMgr.parse((StreamRDF)this, input, baseUri, Lang.RDFXML);
                    break;
                }
                case N3: 
                case TURTLE: {
                    RDFDataMgr.parse((StreamRDF)this, input, baseUri, Lang.TURTLE);
                    break;
                }
                default: {
                    throw new NotImplementedException("Parser not found for format " + (Object)((Object)notation));
                }
            }
        }
        catch (Exception e2) {
            log.error("Unexpected exception.", e2);
            throw new ParserException(e2);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void triple(Triple parsedTriple) {
        this.triple.setAll(JenaNodeFormatter.format(parsedTriple.getSubject()), JenaNodeFormatter.format(parsedTriple.getPredicate()), JenaNodeFormatter.format(parsedTriple.getObject()));
        this.callback.processTriple(this.triple, 0L);
    }

    @Override
    public void quad(Quad quad) {
        this.triple.setAll(JenaNodeFormatter.format(quad.getSubject()), JenaNodeFormatter.format(quad.getPredicate()), JenaNodeFormatter.format(quad.getObject()));
        this.callback.processTriple(this.triple, 0L);
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri) {
    }

    @Override
    public void finish() {
    }
}

