/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.disk;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class LongArrayDisk {
    private static final long MAPPING_SIZE = 0x40000000L;
    private RandomAccessFile array = null;
    private MappedByteBuffer[] mappings_array;
    private long size;
    private String location;

    public LongArrayDisk(String location, long size) {
        try {
            this.location = location;
            this.size = size;
            this.array = new RandomAccessFile(location, "rw");
            size = 8L * size;
            int blocks = (int)Math.ceil((double)size / 1.073741824E9);
            this.mappings_array = new MappedByteBuffer[blocks];
            for (int block = 0; block < blocks; ++block) {
                long size2 = 0x40000000L;
                if (block + 1 == blocks) {
                    size2 = Math.min(0x40000000L, size % 0x40000000L);
                }
                this.mappings_array[block] = this.array.getChannel().map(FileChannel.MapMode.READ_WRITE, (long)block * 0x40000000L, size2);
            }
            for (long i = 0L; i < this.size; ++i) {
                if (i % 10000000L == 0L) {
                    for (int b = 0; b < blocks; ++b) {
                        this.mappings_array[b].force();
                    }
                }
                this.set(i, 0L);
            }
        }
        catch (IOException e2) {
            try {
                this.array.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e2.printStackTrace();
        }
    }

    public long get(long x) {
        long p = x * 8L;
        int block = (int)(p / 0x40000000L);
        int offset = (int)(p % 0x40000000L);
        return this.mappings_array[block].getLong(offset);
    }

    public long getLong(long x) {
        return this.get(x);
    }

    public void set(long x, long y) {
        long p = x * 8L;
        int block = (int)(p / 0x40000000L);
        int offset = (int)(p % 0x40000000L);
        this.mappings_array[block].putLong(offset, y);
    }

    public long length() {
        return this.size;
    }

    public void resize(long newSize) {
        try {
            long oldSize = this.size;
            this.size = newSize;
            long sizeBit = 8L * newSize;
            this.array.setLength(sizeBit);
            int blocks = (int)Math.ceil((double)sizeBit / 1.073741824E9);
            this.mappings_array = new MappedByteBuffer[blocks];
            for (int block = 0; block < blocks; ++block) {
                long sizeMapping = 0x40000000L;
                if (block + 1 == blocks) {
                    sizeMapping = Math.min(0x40000000L, sizeBit % 0x40000000L);
                }
                this.mappings_array[block] = this.array.getChannel().map(FileChannel.MapMode.READ_WRITE, (long)block * 0x40000000L, sizeMapping);
            }
            for (long i = oldSize; i < newSize; ++i) {
                if (i % 10000000L == 0L) {
                    for (int b = 0; b < blocks; ++b) {
                        this.mappings_array[b].force();
                    }
                }
                this.set(i, 0L);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public long getSize() {
        return this.size;
    }
}

