/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;

public class LargeArrayStatistics {
    private LargeArrayStatistics() {
    }

    public static double min(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return a.getDouble(0L);
        }
        double min2 = a.getDouble(0L);
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 1L; i < length; ++i) {
                double elem = a.getDouble(i);
                if (!(elem < min2)) continue;
                min2 = elem;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double min2 = a.getDouble(firstIdx);
                        for (long k = firstIdx + 1L; k < lastIdx; ++k) {
                            double elem = a.getDouble(k);
                            if (!(elem < min2)) continue;
                            min2 = elem;
                        }
                        return min2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    if (!(res < min2)) continue;
                    min2 = res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 1L; i < length; ++i) {
                    double elem = a.getDouble(i);
                    if (!(elem < min2)) continue;
                    min2 = elem;
                }
            }
        }
        return min2;
    }

    public static double max(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return a.getDouble(0L);
        }
        double max2 = a.getDouble(0L);
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 1L; i < length; ++i) {
                double elem = a.getDouble(i);
                if (!(elem > max2)) continue;
                max2 = elem;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double max2 = a.getDouble(firstIdx);
                        for (long k = firstIdx + 1L; k < lastIdx; ++k) {
                            double elem = a.getDouble(k);
                            if (!(elem > max2)) continue;
                            max2 = elem;
                        }
                        return max2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    if (!(res > max2)) continue;
                    max2 = res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 1L; i < length; ++i) {
                    double elem = a.getDouble(i);
                    if (!(elem > max2)) continue;
                    max2 = elem;
                }
            }
        }
        return max2;
    }

    public static double sum(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return (double)a.length() * a.getDouble(0L);
        }
        double sum = 0.0;
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                sum += a.getDouble(i);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            sum += a.getDouble(k);
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    sum += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    sum += a.getDouble(i);
                }
            }
        }
        return sum;
    }

    public static double sumKahan(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return (double)a.length() * a.getDouble(0L);
        }
        double sum = 0.0;
        double c = 0.0;
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                double y = a.getDouble(i) - c;
                double t = sum + y;
                c = t - sum - y;
                sum = t;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum = 0.0;
                        double c = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double y = a.getDouble(k) - c;
                            double t = sum + y;
                            c = t - sum - y;
                            sum = t;
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    sum += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    double y = a.getDouble(i) - c;
                    double t = sum + y;
                    c = t - sum - y;
                    sum = t;
                }
            }
        }
        return sum;
    }

    public static double avg(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return a.getDouble(0L);
        }
        double sum = 0.0;
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                sum += a.getDouble(i);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            sum += a.getDouble(k);
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    sum += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    sum += a.getDouble(i);
                }
            }
        }
        return sum / (double)length;
    }

    public static double avgKahan(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return a.getDouble(0L);
        }
        double sum = 0.0;
        double c = 0.0;
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                double y = a.getDouble(i) - c;
                double t = sum + y;
                c = t - sum - y;
                sum = t;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum = 0.0;
                        double c = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double y = a.getDouble(k) - c;
                            double t = sum + y;
                            c = t - sum - y;
                            sum = t;
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    sum += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    double y = a.getDouble(i) - c;
                    double t = sum + y;
                    c = t - sum - y;
                    sum = t;
                }
            }
        }
        return sum / (double)length;
    }

    public static double std(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return 0.0;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        long length = a.length();
        if (length < 2L) {
            return Double.NaN;
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                double elem = a.getDouble(i);
                sum += elem;
                sum2 += elem * elem;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() {
                        double[] sum = new double[2];
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double elem = a.getDouble(k);
                            sum[0] = sum[0] + elem;
                            sum[1] = sum[1] + elem * elem;
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double[] res = (double[])threads[j].get();
                    sum += res[0];
                    sum2 += res[1];
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    double elem = a.getDouble(i);
                    sum += elem;
                    sum2 += elem * elem;
                }
            }
        }
        return FastMath.sqrt(FastMath.max(0.0, (sum2 /= (double)length) - (sum /= (double)length) * sum));
    }

    public static double stdKahan(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return 0.0;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        long length = a.length();
        if (length < 2L) {
            return Double.NaN;
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                double elem = a.getDouble(i);
                double y = elem - c1;
                double t = sum + y;
                c1 = t - sum - y;
                sum = t;
                double y2 = elem * elem - c2;
                double t2 = sum2 + y2;
                c2 = t2 - sum2 - y2;
                sum2 = t2;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() {
                        double[] sum = new double[2];
                        double c1 = 0.0;
                        double c2 = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double elem = a.getDouble(k);
                            double y = elem - c1;
                            double t = sum[0] + y;
                            c1 = t - sum[0] - y;
                            sum[0] = t;
                            double y2 = elem * elem - c2;
                            double t2 = sum[1] + y2;
                            c2 = t2 - sum[1] - y2;
                            sum[1] = t2;
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double[] res = (double[])threads[j].get();
                    sum += res[0];
                    sum2 += res[1];
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    double elem = a.getDouble(i);
                    double y = elem - c1;
                    double t = sum + y;
                    c1 = t - sum - y;
                    sum = t;
                    double y2 = elem * elem - c2;
                    double t2 = sum2 + y2;
                    c2 = t2 - sum2 - y2;
                    sum2 = t2;
                }
            }
        }
        return FastMath.sqrt(FastMath.max(0.0, (sum2 /= (double)length) - (sum /= (double)length) * sum));
    }
}

