/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.examples;

import java.io.OutputStream;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shacl.GraphValidation;
import org.apache.jena.shacl.ShaclValidationException;
import org.apache.jena.shacl.ShaclValidator;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.sse.SSE;

public class Shacl02_validateTransaction {
    public static void main(String ... args) {
        String SHAPES = "shapes.ttl";
        String DATA = "data2.ttl";
        Graph shapesGraph = RDFDataMgr.loadGraph(SHAPES);
        Graph dataGraph = DatasetGraphFactory.createTxnMem().getDefaultGraph();
        RDFDataMgr.read(dataGraph, DATA);
        Shapes shapes = Shapes.parse(shapesGraph);
        ValidationReport report = ShaclValidator.get().validate(shapes, dataGraph);
        ShLib.printReport(report);
        if (!report.conforms()) {
            System.out.println("** Initial data does not validate");
            System.exit(0);
        }
        System.out.println("++ First transaction");
        try {
            GraphValidation.update(shapes, dataGraph, () -> {
                Triple t = SSE.parseTriple("(:t1 <http://example/ns#p> 'more text')");
                dataGraph.add(t);
            });
            System.out.println("** OK");
        }
        catch (ShaclValidationException ex) {
            System.out.println("** Validation error");
            ShLib.printReport(ex.getReport());
        }
        System.out.println();
        System.out.println("++ Second transaction");
        try {
            GraphValidation.update(shapes, dataGraph, () -> {
                Triple t = SSE.parseTriple("(:t2 <http://example/ns#p> 'second')");
                dataGraph.add(t);
            });
            System.out.println("** OK");
        }
        catch (ShaclValidationException ex) {
            System.out.println("** Validation error");
            ShLib.printReport(ex.getReport());
        }
        System.out.println();
        System.out.println("++ After:");
        RDFDataMgr.write((OutputStream)System.out, dataGraph, Lang.TTL);
    }

    static {
        LogCtl.setLog4j();
    }
}

