/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.sequential;

import org.apache.jena.atlas.lib.ArrayUtils;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.sequential.BuilderSecondaryIndexes;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public class LoaderNodeTupleTable
implements Closeable,
Sync {
    private int numIndexes;
    private TupleIndex primaryIndex;
    private TupleIndex[] secondaryIndexes;
    private NodeTupleTable nodeTupleTable;
    private boolean dropAndRebuildIndexes;
    private long count = 0L;
    private long countTriples = 0L;
    private long countQuads = 0L;
    private String itemsName;
    private final MonitorOutput output;
    private static Object lock = new Object();

    public LoaderNodeTupleTable(NodeTupleTable nodeTupleTable, MonitorOutput output, String itemsName) {
        this.nodeTupleTable = nodeTupleTable;
        this.itemsName = itemsName;
        this.output = output;
    }

    protected void loadPrepare() {
        this.dropAndRebuildIndexes = this.nodeTupleTable.isEmpty();
        if (this.dropAndRebuildIndexes) {
            this.dropSecondaryIndexes();
        } else {
            this.output.print("** Load into %s table with existing data", this.itemsName);
        }
    }

    protected void loadSecondaryIndexes() {
        if (this.count > 0L && this.dropAndRebuildIndexes) {
            BuilderSecondaryIndexes.createSecondaryIndexes(this.output, this.primaryIndex, this.secondaryIndexes);
        }
        this.attachSecondaryIndexes();
    }

    public void loadStart() {
    }

    public void loadFinish() {
    }

    public void loadDataStart() {
        this.loadPrepare();
    }

    public void loadDataFinish() {
        if (this.count > 0L) {
            // empty if block
        }
        this.loadSecondaryIndexes();
    }

    public void load(Node ... nodes) {
        if (nodes.length == 3) {
            ++this.countTriples;
        }
        if (nodes.length == 4) {
            ++this.countQuads;
        }
        ++this.count;
        this.nodeTupleTable.addRow(nodes);
    }

    public void sync(boolean force) {
    }

    @Override
    public void sync() {
    }

    @Override
    public void close() {
        this.sync();
    }

    private void dropSecondaryIndexes() {
        this.numIndexes = this.nodeTupleTable.getTupleTable().numIndexes();
        this.primaryIndex = this.nodeTupleTable.getTupleTable().getIndex(0);
        this.secondaryIndexes = ArrayUtils.alloc(TupleIndex.class, this.numIndexes - 1);
        System.arraycopy(this.nodeTupleTable.getTupleTable().getIndexes(), 1, this.secondaryIndexes, 0, this.numIndexes - 1);
        for (int i = 1; i < this.numIndexes; ++i) {
            this.nodeTupleTable.getTupleTable().setTupleIndex(i, null);
        }
    }

    private void attachSecondaryIndexes() {
        for (int i = 1; i < this.numIndexes; ++i) {
            this.nodeTupleTable.getTupleTable().setTupleIndex(i, this.secondaryIndexes[i - 1]);
        }
    }

    private static void sync(TupleIndex[] indexes) {
        for (TupleIndex idx : indexes) {
            if (idx == null) continue;
            idx.sync();
        }
    }

    private static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }
}

