/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.database_processing;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.query.QuerySolution;
import org.molgenis.vibe.core.database_processing.QueryRunner;
import org.molgenis.vibe.core.database_processing.query_string_creation.QueryStringGenerator;
import org.molgenis.vibe.core.formats.Source;
import org.molgenis.vibe.core.io.input.ModelReader;

public abstract class DisgenetRdfDataRetriever {
    private ModelReader modelReader;
    private Map<URI, Source> sources = new HashMap<URI, Source>();

    protected ModelReader getModelReader() {
        return this.modelReader;
    }

    protected Map<URI, Source> getSources() {
        return this.sources;
    }

    protected DisgenetRdfDataRetriever(ModelReader modelReader) {
        this.modelReader = Objects.requireNonNull(modelReader);
    }

    public abstract void run() throws IOException;

    protected void retrieveSources() {
        QueryRunner query = new QueryRunner(this.getModelReader().getModel(), QueryStringGenerator.getSources());
        while (query.hasNext()) {
            QuerySolution result = query.next();
            URI sourceUri = URI.create(result.get("source").asResource().getURI());
            this.sources.put(sourceUri, new Source(sourceUri, result.get("sourceTitle").asLiteral().getString(), result.get("sourceLevel").asResource().getURI()));
        }
        query.close();
    }
}

