/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.io.input;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.molgenis.vibe.core.io.input.ModelReader;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdtjena.HDTGraph;

public class HdtFileReader
implements ModelReader {
    private Model model;
    private HDT hdt;
    private HDTGraph graph;

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void close() {
        this.model.close();
        this.graph.close();
        try {
            this.hdt.close();
        }
        catch (IOException e2) {
            System.err.println("An error occurred while trying to close the HDT.");
        }
    }

    public HdtFileReader(Path file) throws IOException {
        this(file.toString());
    }

    public HdtFileReader(String file) throws IOException {
        this.hdt = HDTManager.loadIndexedHDT(file, null);
        this.graph = new HDTGraph(this.hdt);
        this.model = ModelFactory.createModelForGraph(this.graph);
    }
}

