/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.ontology_processing;

import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.formats.PhenotypeNetwork;
import org.molgenis.vibe.core.formats.PhenotypeNetworkCollection;

public abstract class PhenotypesRetriever {
    private OntModel model;
    private Collection<Phenotype> inputPhenotypes;
    private int maxDistance;
    private PhenotypeNetworkCollection phenotypeNetworkCollection = new PhenotypeNetworkCollection();

    public Collection<Phenotype> getInputPhenotypes() {
        return this.inputPhenotypes;
    }

    public PhenotypeNetworkCollection getPhenotypeNetworkCollection() {
        return this.phenotypeNetworkCollection;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public PhenotypesRetriever(OntModel model, Collection<Phenotype> inputPhenotypes, int maxDistance) {
        this.model = Objects.requireNonNull(model);
        this.inputPhenotypes = Objects.requireNonNull(inputPhenotypes);
        this.maxDistance = Objects.requireNonNull(maxDistance);
    }

    protected OntClass retrievePhenotypeFromModel(Phenotype phenotype) {
        return this.model.getOntClass(phenotype.getUri().toString());
    }

    public abstract void run();

    protected boolean skippableUri(OntClass phenotypeOC) {
        return phenotypeOC.getURI().startsWith("http://purl.obolibrary.org/obo/UPHENO_");
    }

    protected void addPhenotypeToNetwork(OntClass phenotypeOC, PhenotypeNetwork network, int distance) {
        Phenotype currentPhenotype = new Phenotype(URI.create(phenotypeOC.getURI()));
        network.add(currentPhenotype, distance);
    }
}

