/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.disk.LongArrayDisk;
import org.rdfhdt.hdt.util.io.IOUtil;

public class Bitmap64Disk {
    protected static final int LOGW = 6;
    protected static final int W = 64;
    protected long numbits = 0L;
    protected LongArrayDisk words;

    public Bitmap64Disk(String location) {
        this(location, 64L);
    }

    public Bitmap64Disk(String location, long nbits) {
        this.words = new LongArrayDisk(location, Bitmap64Disk.numWords(nbits));
    }

    protected static int wordIndex(long bitIndex) {
        return (int)(bitIndex >>> 6);
    }

    public static long numWords(long numbits) {
        return (numbits - 1L >>> 6) + 1L;
    }

    public static long numBytes(long numbits) {
        return (numbits - 1L >>> 3) + 1L;
    }

    protected static int lastWordNumBits(long numbits) {
        if (numbits == 0L) {
            return 0;
        }
        return (int)((numbits - 1L) % 64L) + 1;
    }

    protected final void ensureSize(int wordsRequired) {
        this.words.resize(Math.max(this.words.getSize() * 2L, (long)wordsRequired));
    }

    public void trim(long numbits) {
        this.numbits = numbits;
    }

    public void trimToSize() {
        int wordNum = (int)Bitmap64Disk.numWords(this.numbits);
        if ((long)wordNum != this.words.length()) {
            this.words.resize(wordNum);
        }
    }

    public boolean access(long bitIndex) {
        if (bitIndex < 0L) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = Bitmap64Disk.wordIndex(bitIndex);
        if ((long)wordIndex >= this.words.length()) {
            return false;
        }
        return (this.words.get(wordIndex) & 1L << (int)bitIndex) != 0L;
    }

    public void append(boolean value) {
        this.set(this.numbits++, value);
    }

    public void set(long bitIndex, boolean value) {
        if (bitIndex < 0L) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = Bitmap64Disk.wordIndex(bitIndex);
        this.ensureSize(wordIndex + 1);
        if (value) {
            this.words.set(wordIndex, this.words.get(wordIndex) | 1L << (int)bitIndex);
        } else {
            this.words.set(wordIndex, this.words.get(wordIndex) & (1L << (int)bitIndex ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.numbits = Math.max(this.numbits, bitIndex + 1L);
    }

    public long selectPrev1(long start) {
        throw new NotImplementedException();
    }

    public long selectNext1(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int wordIndex = Bitmap64Disk.wordIndex(fromIndex);
        if ((long)wordIndex >= this.words.length()) {
            return -1L;
        }
        long word = this.words.get(wordIndex) & -1L << (int)fromIndex;
        while (word == 0L) {
            if ((long)(++wordIndex) == this.words.length()) {
                return -1L;
            }
            word = this.words.get(wordIndex);
        }
        return (long)wordIndex * 64L + (long)Long.numberOfTrailingZeros(word);
    }

    public long getWord(int word) {
        return this.words.get(word);
    }

    public long getNumBits() {
        return this.numbits;
    }

    public long getSizeBytes() {
        return Bitmap64Disk.numWords(this.numbits) * 8L;
    }

    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        VByte.encode(out, this.numbits);
        out.writeCRC();
        out.setCRC(new CRC32());
        int numwords = (int)Bitmap64Disk.numWords(this.numbits);
        for (int i = 0; i < numwords - 1; ++i) {
            IOUtil.writeLong(out, this.words.get(i));
        }
        if (numwords > 0) {
            int lastWordUsed = Bitmap64Disk.lastWordNumBits(this.numbits);
            BitUtil.writeLowerBitsByteAligned(this.words.get(numwords - 1), lastWordUsed, out);
        }
        out.writeCRC();
    }

    public void load(InputStream input, ProgressListener listener) throws IOException {
    }

    public String toString() {
        StringBuilder str2 = new StringBuilder();
        for (long i = 0L; i < this.numbits; ++i) {
            str2.append(this.access(i) ? (char)'1' : '0');
        }
        return str2.toString();
    }

    public long getRealSizeBytes() {
        return this.words.length() * 8L;
    }
}

