/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.listener.ProgressListener;

public class DictionarySectionCache
implements DictionarySectionPrivate {
    final int CACHE_ENTRIES = 128;
    private final DictionarySectionPrivate child;
    final Map<CharSequence, Long> cacheString = new LinkedHashMap<CharSequence, Long>(129, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<CharSequence, Long> eldest) {
            return this.size() > 128;
        }
    };
    final Map<Long, CharSequence> cacheID = new LinkedHashMap<Long, CharSequence>(129, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<Long, CharSequence> eldest) {
            return this.size() > 128;
        }
    };

    public DictionarySectionCache(DictionarySectionPrivate child) {
        this.child = child;
    }

    @Override
    public long locate(CharSequence s) {
        Long o = this.cacheString.get(s);
        if (o == null) {
            o = this.child.locate(s);
            this.cacheString.put(s, o);
        }
        return o;
    }

    @Override
    public CharSequence extract(long pos) {
        CharSequence o = this.cacheID.get(pos);
        if (o == null) {
            o = this.child.extract(pos);
            this.cacheID.put(pos, o);
        }
        return o;
    }

    @Override
    public long size() {
        return this.child.size();
    }

    @Override
    public long getNumberOfElements() {
        return this.child.getNumberOfElements();
    }

    @Override
    public Iterator<? extends CharSequence> getSortedEntries() {
        return this.child.getSortedEntries();
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        this.child.save(output, listener);
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        this.child.load(input, listener);
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        this.child.load(other, listener);
    }

    @Override
    public void close() throws IOException {
        this.child.close();
    }
}

