/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.listener.ProgressListener;

public class DictionarySectionCacheAll
implements DictionarySectionPrivate {
    final int CACHE_ENTRIES = 128;
    private final DictionarySectionPrivate child;
    private final boolean preload;
    Map<CharSequence, Long> cacheString;
    CharSequence[] cacheID;

    public DictionarySectionCacheAll(DictionarySectionPrivate child, boolean preload) {
        this.child = child;
        this.preload = preload;
        this.cacheString = new HashMap<CharSequence, Long>((int)(child.getNumberOfElements() * 2L));
        this.cacheID = new CharSequence[(int)child.getNumberOfElements()];
        if (preload) {
            Iterator<? extends CharSequence> it = child.getSortedEntries();
            long pos = 0L;
            while (it.hasNext()) {
                this.cacheID[(int)pos] = it.next();
                this.cacheString.put(this.cacheID[(int)pos], pos);
                ++pos;
            }
        }
    }

    @Override
    public long locate(CharSequence s) {
        Long o = this.cacheString.get(s);
        if (o == null) {
            o = this.child.locate(s);
            this.cacheString.put(s, o);
        }
        return o;
    }

    @Override
    public final CharSequence extract(long pos) {
        if (this.preload) {
            return this.cacheID[(int)(pos - 1L)];
        }
        if (pos == 0L) {
            return null;
        }
        CharSequence o = this.cacheID[(int)(pos - 1L)];
        if (o == null) {
            this.cacheID[(int)(pos - 1L)] = o = this.child.extract(pos);
        }
        return o;
    }

    @Override
    public long size() {
        return this.child.size();
    }

    @Override
    public long getNumberOfElements() {
        return this.child.getNumberOfElements();
    }

    @Override
    public Iterator<? extends CharSequence> getSortedEntries() {
        return this.child.getSortedEntries();
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        this.child.save(output, listener);
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        this.child.load(input, listener);
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        this.child.load(other, listener);
    }

    @Override
    public void close() throws IOException {
        this.cacheString = null;
        this.cacheID = null;
        this.child.close();
    }
}

