/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64Big;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.Mutable;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.ReplazableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PFCDictionarySectionBig
implements DictionarySectionPrivate {
    private static final Logger log = LoggerFactory.getLogger(PFCDictionarySectionBig.class);
    public static final int TYPE_INDEX = 2;
    public static final int DEFAULT_BLOCK_SIZE = 16;
    public static final int BLOCK_PER_BUFFER = 1000000;
    byte[][] data;
    long[] posFirst;
    protected SequenceLog64Big blocks;
    protected int blocksize;
    protected int numstrings;
    protected long size;
    static int filecounter = 0;

    public PFCDictionarySectionBig(HDTOptions spec) {
        this.blocksize = (int)spec.getInt("pfc.blocksize");
        if (this.blocksize == 0) {
            this.blocksize = 16;
        }
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        this.blocks = new SequenceLog64Big(BitUtil.log2(other.size()), other.getNumberOfElements() / (long)this.blocksize);
        log.info("numbits:{}", (Object)BitUtil.log2(other.size()));
        Iterator<? extends CharSequence> it = other.getSortedEntries();
        this.load(it, other.getNumberOfElements(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Iterator<? extends CharSequence> it, long numentries, ProgressListener listener) {
        FileOutputStream out;
        File file;
        this.blocks = new SequenceLog64Big(64, numentries / (long)this.blocksize);
        this.numstrings = 0;
        ++filecounter;
        try {
            file = File.createTempFile("test", ".tmp");
            out = new FileOutputStream(file);
        }
        catch (IOException e2) {
            throw new RuntimeException("Error creating temporary file.", e2);
        }
        long byteoutsize = 0L;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(16384);
        CharSequence previousStr = null;
        try {
            while (it.hasNext()) {
                CharSequence str2 = it.next();
                if (this.numstrings % this.blocksize == 0) {
                    byteOut.flush();
                    this.blocks.append(byteoutsize += (long)byteOut.size());
                    byteOut.writeTo(out);
                    byteOut.reset();
                    ByteStringUtil.append(byteOut, str2, 0);
                } else {
                    int delta = ByteStringUtil.longestCommonPrefix(previousStr, str2);
                    VByte.encode(byteOut, delta);
                    ByteStringUtil.append(byteOut, str2, delta);
                }
                byteOut.write(0);
                ++this.numstrings;
                previousStr = str2;
            }
            byteOut.flush();
            this.blocks.append(byteoutsize += (long)byteOut.size());
            this.blocks.aggressiveTrimToSize();
            byteOut.flush();
            byteOut.writeTo(out);
            out.close();
            FileInputStream in = new FileInputStream(file);
            int block = 0;
            int buffer = 0;
            long bytePos = 0L;
            long numBlocks = this.blocks.getNumberOfElements();
            long numBuffers = 1L + numBlocks / 1000000L;
            this.data = new byte[(int)numBuffers][];
            this.posFirst = new long[(int)numBuffers];
            while ((long)block < numBlocks - 1L) {
                int nextBlock = (int)Math.min(numBlocks - 1L, (long)(block + 1000000));
                long nextBytePos = this.blocks.get(nextBlock);
                this.data[buffer] = IOUtil.readBuffer(in, (int)(nextBytePos - bytePos), null);
                this.posFirst[buffer] = bytePos;
                bytePos = nextBytePos;
                block += 1000000;
                ++buffer;
            }
        }
        catch (IOException e3) {
            log.error("Unexpected exception.", e3);
        }
        finally {
            try {
                out.close();
                file.delete();
            }
            catch (IOException e4) {
                log.error("Unexpected exception.", e4);
            }
        }
    }

    protected int locateBlock(CharSequence str2) {
        int high;
        int low = 0;
        int max2 = high = (int)this.blocks.getNumberOfElements() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = mid == max2 ? -1 : ByteStringUtil.strcmp(str2, this.data[mid / 1000000], (int)(this.blocks.get(mid) - this.posFirst[mid / 1000000]));
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public long locate(CharSequence str2) {
        long idblock;
        long blocknum = this.locateBlock(str2);
        if (blocknum >= 0L) {
            return blocknum * (long)this.blocksize + 1L;
        }
        if ((blocknum = -blocknum - 2L) >= 0L && (idblock = (long)this.locateInBlock(blocknum, str2)) != 0L) {
            return blocknum * (long)this.blocksize + idblock + 1L;
        }
        return 0L;
    }

    protected int locateInBlock(long blocknum, CharSequence str2) {
        ReplazableString tempString = new ReplazableString();
        Mutable<Long> delta = new Mutable<Long>(0L);
        int idInBlock = 0;
        int cshared = 0;
        byte[] block = this.data[(int)(blocknum / 1000000L)];
        int pos = (int)(this.blocks.get(blocknum) - this.posFirst[(int)(blocknum / 1000000L)]);
        int slen = ByteStringUtil.strlen(block, pos);
        tempString.append(block, pos, slen);
        pos += slen + 1;
        ++idInBlock;
        while (idInBlock < this.blocksize && pos < block.length) {
            pos += VByte.decode(block, pos, delta);
            slen = ByteStringUtil.strlen(block, pos);
            tempString.replace(delta.getValue().intValue(), block, pos, slen);
            if (delta.getValue() < (long)cshared) {
                idInBlock = 0;
                break;
            }
            if ((cshared += ByteStringUtil.longestCommonPrefix(tempString, str2, cshared)) == str2.length() && tempString.length() == str2.length()) {
                return idInBlock;
            }
            pos += slen + 1;
            ++idInBlock;
        }
        if (pos == block.length || idInBlock == this.blocksize) {
            idInBlock = 0;
        }
        return idInBlock;
    }

    @Override
    public CharSequence extract(long id) {
        if (id < 1L || id > (long)this.numstrings) {
            return null;
        }
        long blockid = (id - 1L) / (long)this.blocksize;
        long nstring = (id - 1L) % (long)this.blocksize;
        byte[] block = this.data[(int)(blockid / 1000000L)];
        int pos = (int)(this.blocks.get(blockid) - this.posFirst[(int)(blockid / 1000000L)]);
        int len = ByteStringUtil.strlen(block, pos);
        Mutable<Long> delta = new Mutable<Long>(0L);
        ReplazableString tempString = new ReplazableString();
        tempString.append(block, pos, len);
        int i = 0;
        while ((long)i < nstring) {
            pos += len + 1;
            pos += VByte.decode(block, pos, delta);
            len = ByteStringUtil.strlen(block, pos);
            tempString.replace(delta.getValue().intValue(), block, pos, len);
            ++i;
        }
        return new CompactString(tempString).getDelayed();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getNumberOfElements() {
        return this.numstrings;
    }

    public Iterator<CharSequence> getSortedEntries() {
        return new Iterator<CharSequence>(){
            int pos;

            @Override
            public boolean hasNext() {
                return (long)this.pos < PFCDictionarySectionBig.this.getNumberOfElements();
            }

            @Override
            public CharSequence next() {
                ++this.pos;
                return PFCDictionarySectionBig.this.extract(this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        int i;
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(2);
        VByte.encode(out, this.numstrings);
        long datasize = 0L;
        for (i = 0; i < this.data.length; ++i) {
            datasize = (long)this.data[i].length + datasize;
        }
        log.info("datasize:{}", (Object)datasize);
        VByte.encode(out, datasize);
        VByte.encode(out, this.blocksize);
        out.writeCRC();
        this.blocks.save(output, listener);
        out.setCRC(new CRC32());
        for (i = 0; i < this.data.length; ++i) {
            IOUtil.writeBuffer(out, this.data[i], 0, this.data[i].length, listener);
        }
        out.writeCRC();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        CRCInputStream in = new CRCInputStream(input, new CRC8());
        int type = in.read();
        if (type != 2) {
            throw new IllegalFormatException("Trying to read a DictionarySectionPFC from data that is not of the suitable type");
        }
        this.numstrings = (int)VByte.decode(in);
        this.size = VByte.decode(in);
        this.blocksize = (int)VByte.decode(in);
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Dictionary Section Plain Front Coding Header.");
        }
        this.blocks = new SequenceLog64Big();
        this.blocks.load(input, listener);
        in.setCRC(new CRC32());
        int block = 0;
        int buffer = 0;
        long bytePos = 0L;
        long numBlocks = this.blocks.getNumberOfElements();
        long numBuffers = 1L + numBlocks / 1000000L;
        this.data = new byte[(int)numBuffers][];
        this.posFirst = new long[(int)numBuffers];
        while ((long)block < numBlocks - 1L) {
            int nextBlock = (int)Math.min(numBlocks - 1L, (long)(block + 1000000));
            long nextBytePos = this.blocks.get(nextBlock);
            this.data[buffer] = IOUtil.readBuffer(in, (int)(nextBytePos - bytePos), null);
            this.posFirst[buffer] = bytePos;
            bytePos = nextBytePos;
            block += 1000000;
            ++buffer;
        }
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Dictionary Section Plain Front Coding Data.");
        }
    }

    @Override
    public void close() throws IOException {
        this.data = null;
        this.posFirst = null;
        this.blocks.close();
        this.blocks = null;
    }
}

