/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.TripleWriter;
import org.rdfhdt.hdt.triples.TripleString;

public abstract class HDTManager {
    private static HDTManager instance;

    private static HDTManager getInstance() {
        if (instance == null) {
            try {
                Class<?> managerImplClass = Class.forName("org.rdfhdt.hdt.pro.HDTManagerProImpl");
                instance = (HDTManager)managerImplClass.newInstance();
            }
            catch (Exception e1) {
                try {
                    Class<?> managerImplClass = Class.forName("org.rdfhdt.hdt.hdt.HDTManagerImpl");
                    instance = (HDTManager)managerImplClass.newInstance();
                }
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException("Class org.rdfhdt.hdt.hdt.HDTManagerImpl not found. Did you include the HDT implementation jar?");
                }
                catch (InstantiationException e3) {
                    throw new RuntimeException("Cannot create implementation for HDTManager. Does the class org.rdfhdt.hdt.hdt.HDTManagerImpl inherit from HDTManager?");
                }
                catch (IllegalAccessException e4) {
                    throw new RuntimeException(e4);
                }
            }
        }
        return instance;
    }

    public static HDTOptions readOptions(String file) throws IOException {
        return HDTManager.getInstance().doReadOptions(file);
    }

    public static HDT loadHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doLoadHDT(hdtFileName, listener);
    }

    public static HDT loadHDT(String hdtFileName) throws IOException {
        return HDTManager.getInstance().doLoadHDT(hdtFileName, null);
    }

    public static HDT mapHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doMapHDT(hdtFileName, listener);
    }

    public static HDT mapHDT(String hdtFileName) throws IOException {
        return HDTManager.getInstance().doMapHDT(hdtFileName, null);
    }

    public static HDT loadHDT(InputStream hdtFile, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doLoadHDT(hdtFile, listener);
    }

    public static HDT loadHDT(InputStream hdtFile) throws IOException {
        return HDTManager.getInstance().doLoadHDT(hdtFile, null);
    }

    public static HDT loadIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doLoadIndexedHDT(hdtFileName, listener);
    }

    public static HDT loadIndexedHDT(String hdtFileName) throws IOException {
        return HDTManager.getInstance().doLoadIndexedHDT(hdtFileName, null);
    }

    public static HDT mapIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doMapIndexedHDT(hdtFileName, listener);
    }

    public static HDT mapIndexedHDT(String hdtFileName) throws IOException {
        return HDTManager.getInstance().doMapIndexedHDT(hdtFileName, null);
    }

    public static HDT loadIndexedHDT(InputStream hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doLoadIndexedHDT(hdtFileName, listener);
    }

    public static HDT loadIndexedHDT(InputStream hdtFileName) throws IOException {
        return HDTManager.getInstance().doLoadIndexedHDT(hdtFileName, null);
    }

    public static HDT indexedHDT(HDT hdt, ProgressListener listener) {
        return HDTManager.getInstance().doIndexedHDT(hdt, listener);
    }

    public static HDT generateHDT(String rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(rdfFileName, baseURI, rdfNotation, hdtFormat, listener);
    }

    public static HDT generateHDT(Iterator<TripleString> iterator, String baseURI, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(iterator, baseURI, hdtFormat, listener);
    }

    public static TripleWriter getHDTWriter(OutputStream out, String baseURI, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doGetHDTWriter(out, baseURI, hdtFormat);
    }

    public static TripleWriter getHDTWriter(String outFile, String baseURI, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doGetHDTWriter(outFile, baseURI, hdtFormat);
    }

    public static HDT catHDT(String location, String hdtFileName1, String hdtFileName2, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doHDTCat(location, hdtFileName1, hdtFileName2, hdtFormat, listener);
    }

    protected abstract HDTOptions doReadOptions(String var1) throws IOException;

    protected abstract HDT doLoadHDT(String var1, ProgressListener var2) throws IOException;

    protected abstract HDT doLoadHDT(InputStream var1, ProgressListener var2) throws IOException;

    protected abstract HDT doMapHDT(String var1, ProgressListener var2) throws IOException;

    protected abstract HDT doLoadIndexedHDT(String var1, ProgressListener var2) throws IOException;

    protected abstract HDT doLoadIndexedHDT(InputStream var1, ProgressListener var2) throws IOException;

    protected abstract HDT doMapIndexedHDT(String var1, ProgressListener var2) throws IOException;

    protected abstract HDT doIndexedHDT(HDT var1, ProgressListener var2);

    protected abstract HDT doGenerateHDT(String var1, String var2, RDFNotation var3, HDTOptions var4, ProgressListener var5) throws IOException, ParserException;

    protected abstract HDT doGenerateHDT(Iterator<TripleString> var1, String var2, HDTOptions var3, ProgressListener var4) throws IOException;

    protected abstract TripleWriter doGetHDTWriter(OutputStream var1, String var2, HDTOptions var3) throws IOException;

    protected abstract TripleWriter doGetHDTWriter(String var1, String var2, HDTOptions var3) throws IOException;

    protected abstract HDT doHDTCat(String var1, String var2, String var3, HDTOptions var4, ProgressListener var5) throws IOException;
}

