/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.header;

import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleString;

public class HeaderUtil {
    private HeaderUtil() {
    }

    public static String cleanURI(CharSequence str2) {
        String uri = str2.toString();
        if (uri != null && uri.length() >= 2 && uri.charAt(0) == '<' && uri.charAt(uri.length() - 1) == '>') {
            return uri.substring(1, uri.length() - 1);
        }
        return uri;
    }

    private static String cleanLiteral(String uri) {
        if (uri != null && uri.length() >= 2 && uri.charAt(0) == '\"' && uri.charAt(uri.length() - 1) == '\"') {
            return uri.substring(1, uri.length() - 1);
        }
        return uri;
    }

    public static String getProperty(Header header, String subject, String predicate) throws NotFoundException {
        IteratorTripleString it = header.search(HeaderUtil.cleanURI(subject), HeaderUtil.cleanURI(predicate), "");
        if (it.hasNext()) {
            TripleString ts = (TripleString)it.next();
            return ts.getObject().toString();
        }
        throw new NotFoundException();
    }

    public static int getPropertyInt(Header header, String subject, String predicate) throws NotFoundException {
        String str2 = HeaderUtil.getProperty(header, subject, predicate);
        if (str2 != null) {
            try {
                return Integer.parseInt(str2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new NotFoundException();
    }

    public static long getPropertyLong(Header header, String subject, String predicate) throws NotFoundException {
        String str2 = HeaderUtil.getProperty(header, subject, predicate);
        if (str2 != null) {
            try {
                return Long.parseLong(HeaderUtil.cleanLiteral(str2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new NotFoundException();
    }

    public static String getSubject(Header header, String predicate, String object) throws NotFoundException {
        IteratorTripleString it = header.search("", predicate, object);
        if (it.hasNext()) {
            TripleString ts = (TripleString)it.next();
            return ts.getObject().toString();
        }
        throw new NotFoundException();
    }

    public static String getBaseURI(Header header) throws NotFoundException {
        return HeaderUtil.getSubject(header, "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>", "<http://purl.org/HDT/hdt#Dataset>");
    }
}

