/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.List;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;

public class ListTripleIDIterator
implements IteratorTripleID {
    private List<TripleID> triplesList;
    private int pos;

    public ListTripleIDIterator(List<TripleID> triplesList) {
        this.triplesList = triplesList;
        this.pos = 0;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.triplesList.size();
    }

    @Override
    public TripleID next() {
        return this.triplesList.get(this.pos++);
    }

    @Override
    public boolean hasPrevious() {
        return this.pos > 0;
    }

    @Override
    public TripleID previous() {
        return this.triplesList.get(--this.pos);
    }

    @Override
    public void goToStart() {
        this.pos = 0;
    }

    @Override
    public long estimatedNumResults() {
        return this.triplesList.size();
    }

    @Override
    public ResultEstimationType numResultEstimation() {
        return ResultEstimationType.EXACT;
    }

    @Override
    public boolean canGoTo() {
        return true;
    }

    @Override
    public void goTo(long pos) {
        this.pos = (int)pos;
    }

    @Override
    public TripleComponentOrder getOrder() {
        return TripleComponentOrder.Unknown;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

