/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.NonCloseInputStream;

public class RDFParserZip
implements RDFParserCallback {
    @Override
    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            InputStream input = IOUtil.getFileInputStream(fileName);
            this.doParse(input, baseUri, notation, callback);
            input.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ParserException();
        }
    }

    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zin = new ZipInputStream(input);
            NonCloseInputStream nonCloseIn = new NonCloseInputStream(zin);
            while ((zipEntry = zin.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                try {
                    RDFNotation guessnot = RDFNotation.guess(zipEntry.getName());
                    System.out.println("Parse from zip: " + zipEntry.getName() + " as " + (Object)((Object)guessnot));
                    RDFParserCallback parser = RDFParserFactory.getParserCallback(guessnot);
                    parser.doParse(nonCloseIn, baseUri, guessnot, callback);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (ParserException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            throw new ParserException();
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new ParserException();
        }
    }
}

