/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.rdfhdt.hdt.compact.bitmap.Bitmap375;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class BitmapTriplesCat {
    private String location;

    public BitmapTriplesCat(String location) {
        this.location = location;
    }

    public void cat(IteratorTripleID it, ProgressListener listener) {
        try {
            long number = it.estimatedNumResults();
            SequenceLog64BigDisk vectorY = new SequenceLog64BigDisk(this.location + "vectorY", BitUtil.log2(number), number);
            SequenceLog64BigDisk vectorZ = new SequenceLog64BigDisk(this.location + "vectorZ", BitUtil.log2(number), number);
            Bitmap375 bitY = new Bitmap375();
            Bitmap375 bitZ = new Bitmap375();
            long lastX = 0L;
            long lastY = 0L;
            long lastZ = 0L;
            long numTriples = 0L;
            while (it.hasNext()) {
                TripleID triple = (TripleID)it.next();
                TripleOrderConvert.swapComponentOrder(triple, TripleComponentOrder.SPO, TripleComponentOrder.SPO);
                long x = triple.getSubject();
                long y = triple.getPredicate();
                long z = triple.getObject();
                if (x == 0L || y == 0L || z == 0L) {
                    throw new IllegalFormatException("None of the components of a triple can be null");
                }
                if (numTriples == 0L) {
                    vectorY.append(y);
                    vectorZ.append(z);
                } else if (x != lastX) {
                    if (x != lastX + 1L) {
                        throw new IllegalFormatException("Upper level must be increasing and correlative.");
                    }
                    bitY.append(true);
                    vectorY.append(y);
                    bitZ.append(true);
                    vectorZ.append(z);
                } else if (y != lastY) {
                    if (y < lastY) {
                        throw new IllegalFormatException("Middle level must be increasing for each parent.");
                    }
                    bitY.append(false);
                    vectorY.append(y);
                    bitZ.append(true);
                    vectorZ.append(z);
                } else {
                    if (z < lastZ) {
                        throw new IllegalFormatException("Lower level must be increasing for each parent.");
                    }
                    bitZ.append(false);
                    vectorZ.append(z);
                }
                lastX = x;
                lastY = y;
                lastZ = z;
                ListenerUtil.notifyCond(listener, "Converting to BitmapTriples", numTriples, numTriples, number);
                ++numTriples;
            }
            if (numTriples > 0L) {
                bitY.append(true);
                bitZ.append(true);
            }
            vectorY.aggressiveTrimToSize();
            vectorZ.trimToSize();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.location + "triples"));
            ControlInformation ci = new ControlInformation();
            ci.setType(ControlInfo.Type.TRIPLES);
            ci.setFormat("<http://purl.org/HDT/hdt#triplesBitmap>");
            ci.setInt("order", TripleComponentOrder.SPO.ordinal());
            ci.setType(ControlInfo.Type.TRIPLES);
            ci.save(bos);
            IntermediateListener iListener = new IntermediateListener(listener);
            bitY.save(bos, iListener);
            bitZ.save(bos, iListener);
            vectorY.save(bos, iListener);
            vectorZ.save(bos, iListener);
            Files.delete(Paths.get(this.location + "vectorY", new String[0]));
            Files.delete(Paths.get(this.location + "vectorZ", new String[0]));
            bos.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

