/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.IOException;
import java.io.InputStream;

public class CountInputStream
extends InputStream {
    long total;
    long partial;
    final InputStream in;
    long markTotal;
    long markPartial;

    public CountInputStream(InputStream input) {
        this.in = input;
        this.total = 0L;
        this.partial = 0L;
    }

    public long getTotalBytes() {
        return this.total;
    }

    public long getPartialBytes() {
        return this.partial;
    }

    public void resetPartial() {
        this.partial = 0L;
    }

    @Override
    public int read() throws IOException {
        int value = this.in.read();
        if (value != -1) {
            ++this.partial;
            ++this.total;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int value = this.in.read(b);
        if (value != -1) {
            this.partial += (long)value;
            this.total += (long)value;
        }
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = this.in.read(b, off, len);
        if (value != -1) {
            this.partial += (long)value;
            this.total += (long)value;
        }
        return value;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.partial += skipped;
        this.total += skipped;
        return skipped;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.markTotal = this.total;
        this.markPartial = this.partial;
        if (this.in.markSupported()) {
            this.in.mark(readlimit);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.total = this.markTotal;
        this.partial = this.markPartial;
        this.in.reset();
    }
}

