/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.util;

import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.NotFoundException;

public final class VarAppearance {
    private byte value;
    private static final byte SUBJECT = 1;
    private static final byte PREDICATE = 2;
    private static final byte OBJECT = 4;
    private static final byte SUBJ_OBJ = 5;

    public void setSubject() {
        this.value = (byte)(this.value | 1);
    }

    public void setPredicate() {
        this.value = (byte)(this.value | 2);
    }

    public void setObject() {
        this.value = (byte)(this.value | 4);
    }

    public boolean isSubject() {
        return (1 & this.value) != 0;
    }

    public boolean isPredicate() {
        return (2 & this.value) != 0;
    }

    public boolean isObject() {
        return (4 & this.value) != 0;
    }

    public boolean isSubjectObject() {
        return (5 & this.value) == 5;
    }

    public TripleComponentRole getRole() throws NotFoundException {
        if ((1 & this.value) != 0) {
            return TripleComponentRole.SUBJECT;
        }
        if ((2 & this.value) != 0) {
            return TripleComponentRole.PREDICATE;
        }
        if ((4 & this.value) != 0) {
            return TripleComponentRole.OBJECT;
        }
        throw new NotFoundException("No role set.");
    }

    public void set(TripleComponentRole role) {
        switch (role) {
            case SUBJECT: {
                this.value = (byte)(this.value | 1);
                break;
            }
            case PREDICATE: {
                this.value = (byte)(this.value | 2);
                break;
            }
            case OBJECT: {
                this.value = (byte)(this.value | 4);
            }
        }
    }
}

