/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.storage.prefixes.PrefixEntry;
import org.apache.jena.dboe.storage.prefixes.PrefixLib;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;

public interface PrefixMapI
extends Iterable<PrefixEntry> {
    public Map<String, String> getMapping();

    public Map<String, String> getMappingCopy();

    public StoragePrefixMap getPrefixMapStorage();

    public void add(String var1, String var2);

    public void putAll(PrefixMapI var1);

    public void delete(String var1);

    public void clear();

    public String get(String var1);

    public boolean containPrefix(String var1);

    default public String abbreviate(String uriStr) {
        return PrefixLib.abbreviate(this, uriStr);
    }

    default public Pair<String, String> abbrev(String uriStr) {
        return PrefixLib.abbrev(this, uriStr);
    }

    default public String expand(String prefixedName) {
        return PrefixLib.expand(this, prefixedName);
    }

    default public String expand(String prefix, String localName) {
        return PrefixLib.expand(this, prefix, localName);
    }

    @Override
    default public Iterator<PrefixEntry> iterator() {
        return this.stream().iterator();
    }

    public void forEach(BiConsumer<String, String> var1);

    public Stream<PrefixEntry> stream();

    default public Stream<String> prefixes() {
        return this.stream().map(PrefixEntry::getPrefix);
    }

    public boolean isEmpty();

    public int size();
}

